/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.ScheduledSplit;
import com.facebook.presto.TaskSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.operator.index.IndexSnapshotBuilder;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.operator.index.IndexedData;
import com.facebook.presto.operator.index.PageBuffer;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.index.StreamingIndexedData;
import com.facebook.presto.operator.index.UnloadedIndexKeyRecordSet;
import com.facebook.presto.operator.index.UpdateRequest;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class IndexLoader {
    private final BlockingQueue<UpdateRequest> updateRequests = new LinkedBlockingQueue<UpdateRequest>();
    private final List<Type> outputTypes;
    private final IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider;
    private final int expectedPositions;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats stats;
    private final AtomicReference<TaskContext> taskContextReference = new AtomicReference();
    private final Set<Integer> lookupSourceInputChannels;
    private final List<Integer> keyOutputChannels;
    private final Optional<Integer> keyOutputHashChannel;
    private final List<Type> keyTypes;
    @GuardedBy(value="this")
    private IndexSnapshotLoader indexSnapshotLoader;
    @GuardedBy(value="this")
    private PipelineContext pipelineContext;
    @GuardedBy(value="this")
    private final AtomicReference<IndexSnapshot> indexSnapshotReference;

    public IndexLoader(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, Optional<Integer> keyOutputHashChannel, List<Type> outputTypes, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, int expectedPositions, DataSize maxIndexMemorySize, IndexJoinLookupStats stats) {
        Preconditions.checkNotNull(lookupSourceInputChannels, (Object)"lookupSourceInputChannels is null");
        Preconditions.checkArgument((!lookupSourceInputChannels.isEmpty() ? 1 : 0) != 0, (Object)"lookupSourceInputChannels must not be empty");
        Preconditions.checkNotNull(keyOutputChannels, (Object)"keyOutputChannels is null");
        Preconditions.checkArgument((!keyOutputChannels.isEmpty() ? 1 : 0) != 0, (Object)"keyOutputChannels must not be empty");
        Preconditions.checkNotNull(keyOutputHashChannel, (Object)"keyOutputHashChannel is null");
        Preconditions.checkArgument((lookupSourceInputChannels.size() <= keyOutputChannels.size() ? 1 : 0) != 0, (Object)"Lookup channels must supply a subset of the actual index columns");
        Preconditions.checkNotNull(outputTypes, (Object)"outputTypes is null");
        Preconditions.checkNotNull((Object)indexBuildDriverFactoryProvider, (Object)"indexBuildDriverFactoryProvider is null");
        Preconditions.checkNotNull((Object)expectedPositions, (Object)"expectedPositions is null");
        Preconditions.checkNotNull((Object)maxIndexMemorySize, (Object)"maxIndexMemorySize is null");
        Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
        this.lookupSourceInputChannels = ImmutableSet.copyOf(lookupSourceInputChannels);
        this.keyOutputChannels = ImmutableList.copyOf(keyOutputChannels);
        this.keyOutputHashChannel = keyOutputHashChannel;
        this.outputTypes = ImmutableList.copyOf(outputTypes);
        this.indexBuildDriverFactoryProvider = indexBuildDriverFactoryProvider;
        this.expectedPositions = expectedPositions;
        this.maxIndexMemorySize = maxIndexMemorySize;
        this.stats = stats;
        ImmutableList.Builder keyTypeBuilder = ImmutableList.builder();
        for (int keyOutputChannel : keyOutputChannels) {
            keyTypeBuilder.add((Object)outputTypes.get(keyOutputChannel));
        }
        this.keyTypes = keyTypeBuilder.build();
        this.indexSnapshotReference = new AtomicReference<IndexSnapshot>(new IndexSnapshot(new EmptyLookupSource(outputTypes.size()), new EmptyLookupSource(keyOutputChannels.size())));
    }

    public void setContext(TaskContext taskContext) {
        this.taskContextReference.compareAndSet(null, taskContext);
    }

    public int getChannelCount() {
        return this.outputTypes.size();
    }

    public List<Type> getOutputTypes() {
        return this.outputTypes;
    }

    public IndexSnapshot getIndexSnapshot() {
        return this.indexSnapshotReference.get();
    }

    private static Block[] sliceBlocks(Block[] indexBlocks, int startPosition, int length) {
        Block[] slicedIndexBlocks = new Block[indexBlocks.length];
        for (int i = 0; i < indexBlocks.length; ++i) {
            slicedIndexBlocks[i] = indexBlocks[i].getRegion(startPosition, length);
        }
        return slicedIndexBlocks;
    }

    public IndexedData getIndexedDataForKeys(int position, Block[] indexBlocks) {
        int totalPositions = indexBlocks[0].getPositionCount();
        int remainingPositions = totalPositions - position;
        return this.getIndexedDataForKeys(IndexLoader.sliceBlocks(indexBlocks, position, remainingPositions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexedData getIndexedDataForKeys(Block[] indexBlocks) {
        UpdateRequest myUpdateRequest = new UpdateRequest(indexBlocks);
        this.updateRequests.add(myUpdateRequest);
        IndexLoader indexLoader = this;
        synchronized (indexLoader) {
            if (!myUpdateRequest.isFinished()) {
                this.stats.recordIndexJoinLookup();
                this.initializeStateIfNecessary();
                ArrayList<UpdateRequest> requests = new ArrayList<UpdateRequest>();
                this.updateRequests.drainTo(requests);
                long initialCacheSizeInBytes = this.indexSnapshotLoader.getCacheSizeInBytes();
                if (this.indexSnapshotLoader.load(requests)) {
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                if (initialCacheSizeInBytes > 0L && this.indexSnapshotLoader.load(requests)) {
                    this.stats.recordSuccessfulIndexJoinLookupByCacheReset();
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                if (requests.size() > 1) {
                    Iterables.addAll(this.updateRequests, (Iterable)Iterables.filter(requests, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)myUpdateRequest))));
                    if (this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) {
                        this.stats.recordSuccessfulIndexJoinLookupBySingleRequest();
                        return myUpdateRequest.getFinishedIndexSnapshot();
                    }
                }
                int totalPositions = indexBlocks[0].getPositionCount();
                for (int attemptedPositions = totalPositions / 10; attemptedPositions > 1; attemptedPositions /= 10) {
                    myUpdateRequest = new UpdateRequest(IndexLoader.sliceBlocks(indexBlocks, 0, attemptedPositions));
                    if (!this.indexSnapshotLoader.load((List<UpdateRequest>)ImmutableList.of((Object)myUpdateRequest))) continue;
                    this.stats.recordSuccessfulIndexJoinLookupByLimitedRequest();
                    return myUpdateRequest.getFinishedIndexSnapshot();
                }
                this.stats.recordStreamedIndexJoinLookup();
                return this.streamIndexDataForSingleKey(myUpdateRequest);
            }
        }
        return myUpdateRequest.getFinishedIndexSnapshot();
    }

    public IndexedData streamIndexDataForSingleKey(UpdateRequest updateRequest) {
        Page indexKeyTuple = new Page(IndexLoader.sliceBlocks(updateRequest.getBlocks(), 0, 1));
        PageBuffer pageBuffer = new PageBuffer(100);
        DriverFactory driverFactory = this.indexBuildDriverFactoryProvider.createStreaming(pageBuffer, indexKeyTuple);
        Driver driver = driverFactory.createDriver(this.pipelineContext.addDriverContext());
        PageRecordSet pageRecordSet = new PageRecordSet(this.keyTypes, indexKeyTuple);
        PlanNodeId planNodeId = (PlanNodeId)Iterables.getOnlyElement(driverFactory.getSourceIds());
        driver.updateSource(new TaskSource(planNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)new ScheduledSplit(0L, new Split("index", new IndexSplit(pageRecordSet)))), true));
        return new StreamingIndexedData(this.outputTypes, this.keyTypes, indexKeyTuple, pageBuffer, driver);
    }

    private synchronized void initializeStateIfNecessary() {
        if (this.pipelineContext == null) {
            TaskContext taskContext = this.taskContextReference.get();
            Preconditions.checkState((taskContext != null ? 1 : 0) != 0, (Object)"Task context must be set before index can be built");
            this.pipelineContext = taskContext.addPipelineContext(false, false);
        }
        if (this.indexSnapshotLoader == null) {
            this.indexSnapshotLoader = new IndexSnapshotLoader(this.indexBuildDriverFactoryProvider, this.pipelineContext, this.indexSnapshotReference, this.lookupSourceInputChannels, this.keyTypes, this.keyOutputChannels, this.keyOutputHashChannel, this.expectedPositions, this.maxIndexMemorySize);
        }
    }

    private static class EmptyLookupSource
    implements LookupSource {
        private final int channelCount;

        public EmptyLookupSource(int channelCount) {
            this.channelCount = channelCount;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount;
        }

        @Override
        public long getJoinPosition(int position, Page page, int rawHash) {
            return -2L;
        }

        @Override
        public long getJoinPosition(int position, Page page) {
            return -2L;
        }

        @Override
        public long getNextJoinPosition(long currentPosition) {
            return -2L;
        }

        @Override
        public void appendTo(long position, PageBuilder pageBuilder, int outputChannelOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    @NotThreadSafe
    private static class IndexSnapshotLoader {
        private final DriverFactory driverFactory;
        private final PipelineContext pipelineContext;
        private final Set<Integer> lookupSourceInputChannels;
        private final Set<Integer> allInputChannels;
        private final List<Type> outputTypes;
        private final List<Type> indexTypes;
        private final AtomicReference<IndexSnapshot> indexSnapshotReference;
        private final IndexSnapshotBuilder indexSnapshotBuilder;

        private IndexSnapshotLoader(IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, PipelineContext pipelineContext, AtomicReference<IndexSnapshot> indexSnapshotReference, Set<Integer> lookupSourceInputChannels, List<Type> indexTypes, List<Integer> keyOutputChannels, Optional<Integer> keyOutputHashChannel, int expectedPositions, DataSize maxIndexMemorySize) {
            this.pipelineContext = pipelineContext;
            this.indexSnapshotReference = indexSnapshotReference;
            this.lookupSourceInputChannels = lookupSourceInputChannels;
            this.outputTypes = indexBuildDriverFactoryProvider.getOutputTypes();
            this.indexTypes = indexTypes;
            this.indexSnapshotBuilder = new IndexSnapshotBuilder(this.outputTypes, keyOutputChannels, keyOutputHashChannel, pipelineContext.addDriverContext(), maxIndexMemorySize, expectedPositions);
            this.driverFactory = indexBuildDriverFactoryProvider.createSnapshot(this.indexSnapshotBuilder);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (int i = 0; i < indexTypes.size(); ++i) {
                builder.add((Object)i);
            }
            this.allInputChannels = builder.build();
        }

        public long getCacheSizeInBytes() {
            return this.indexSnapshotBuilder.getMemoryInBytes();
        }

        public boolean load(List<UpdateRequest> requests) {
            UnloadedIndexKeyRecordSet recordSetForLookupSource = new UnloadedIndexKeyRecordSet(this.indexSnapshotReference.get(), this.lookupSourceInputChannels, this.indexTypes, requests);
            Driver driver = this.driverFactory.createDriver(this.pipelineContext.addDriverContext());
            PlanNodeId sourcePlanNodeId = (PlanNodeId)Iterables.getOnlyElement(this.driverFactory.getSourceIds());
            driver.updateSource(new TaskSource(sourcePlanNodeId, (Set<ScheduledSplit>)ImmutableSet.of((Object)new ScheduledSplit(0L, new Split("index", new IndexSplit(recordSetForLookupSource)))), true));
            while (!driver.isFinished()) {
                ListenableFuture<?> process = driver.process();
                Preconditions.checkState((boolean)process.isDone(), (Object)"Driver should never block");
            }
            if (this.indexSnapshotBuilder.isMemoryExceeded()) {
                this.clearCachedData();
                return false;
            }
            UnloadedIndexKeyRecordSet indexKeysRecordSet = this.lookupSourceInputChannels.equals(this.allInputChannels) ? recordSetForLookupSource : new UnloadedIndexKeyRecordSet(this.indexSnapshotReference.get(), this.allInputChannels, this.indexTypes, requests);
            IndexSnapshot newValue = this.indexSnapshotBuilder.createIndexSnapshot(indexKeysRecordSet);
            if (newValue == null) {
                this.clearCachedData();
                return false;
            }
            this.indexSnapshotReference.set(newValue);
            for (UpdateRequest request : requests) {
                request.finished(newValue);
            }
            return true;
        }

        private void clearCachedData() {
            this.indexSnapshotReference.set(new IndexSnapshot(new EmptyLookupSource(this.outputTypes.size()), new EmptyLookupSource(this.indexTypes.size())));
            this.indexSnapshotBuilder.reset();
        }
    }
}

