/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    @Override
    public Type getSerializedType() {
        return DoubleType.DOUBLE;
    }

    @Override
    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            out.writeDouble(state.getDouble()).closeEntry();
        }
    }

    @Override
    public void deserialize(Block block, int index, NullableDoubleState state) {
        state.setNull(block.isNull(index));
        if (!state.isNull()) {
            state.setDouble(DoubleType.DOUBLE.getDouble(block, index));
        }
    }
}

