/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxOrMinByState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.BlockBigArray;

public class MaxOrMinByStateFactory
implements AccumulatorStateFactory<MaxOrMinByState> {
    private final Type valueType;
    private final Type keyType;

    public MaxOrMinByStateFactory(Type valueType, Type keyType) {
        this.valueType = valueType;
        this.keyType = keyType;
    }

    @Override
    public MaxOrMinByState createSingleState() {
        return new SingleMaxOrMinByState(this.keyType, this.valueType);
    }

    @Override
    public Class<? extends MaxOrMinByState> getSingleStateClass() {
        return SingleMaxOrMinByState.class;
    }

    @Override
    public MaxOrMinByState createGroupedState() {
        return new GroupedMaxOrMinByState(this.keyType, this.valueType);
    }

    @Override
    public Class<? extends MaxOrMinByState> getGroupedStateClass() {
        return GroupedMaxOrMinByState.class;
    }

    public static class SingleMaxOrMinByState
    implements MaxOrMinByState {
        private final Type keyType;
        private final Type valueType;
        private Block key;
        private Block value;

        public SingleMaxOrMinByState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public long getEstimatedSize() {
            long size = 0L;
            if (this.key != null) {
                size += (long)this.key.getSizeInBytes();
            }
            if (this.value != null) {
                size += (long)this.value.getSizeInBytes();
            }
            return size;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        @Override
        public Block getKey() {
            return this.key;
        }

        @Override
        public void setKey(Block key) {
            this.key = key;
        }

        @Override
        public Block getValue() {
            return this.value;
        }

        @Override
        public void setValue(Block value) {
            this.value = value;
        }
    }

    public static class GroupedMaxOrMinByState
    extends AbstractGroupedAccumulatorState
    implements MaxOrMinByState {
        private final Type keyType;
        private final Type valueType;
        private final BlockBigArray keys = new BlockBigArray();
        private final BlockBigArray values = new BlockBigArray();

        public GroupedMaxOrMinByState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public void ensureCapacity(long size) {
            this.keys.ensureCapacity(size);
            this.values.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.keys.sizeOf() + this.values.sizeOf();
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        @Override
        public Block getKey() {
            return this.keys.get(this.getGroupId());
        }

        @Override
        public void setKey(Block key) {
            this.keys.set(this.getGroupId(), key);
        }

        @Override
        public Block getValue() {
            return this.values.get(this.getGroupId());
        }

        @Override
        public void setValue(Block value) {
            this.values.set(this.getGroupId(), value);
        }
    }
}

