/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.ArbitraryAggregationState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class ArbitraryAggregationStateSerializer
implements AccumulatorStateSerializer<ArbitraryAggregationState> {
    @Override
    public Type getSerializedType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public void serialize(ArbitraryAggregationState state, BlockBuilder out) {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput((int)state.getEstimatedSize());
        int valueLength = 0;
        if (state.getValue() != null && !state.getValue().isNull(0)) {
            valueLength = state.getValue().getLength(0);
        }
        sliceOutput.writeInt(valueLength);
        if (state.getValue() != null && !state.getValue().isNull(0)) {
            ArbitraryAggregationStateSerializer.appendTo(state.getType(), (SliceOutput)sliceOutput, state.getValue());
        }
        Slice slice = sliceOutput.slice();
        out.writeBytes(slice, 0, slice.length());
        out.closeEntry();
    }

    private static void appendTo(Type type, SliceOutput output, Block block) {
        if (type.getJavaType() == Long.TYPE) {
            output.appendLong(type.getLong(block, 0));
        } else if (type.getJavaType() == Double.TYPE) {
            output.appendDouble(type.getDouble(block, 0));
        } else if (type.getJavaType() == Slice.class) {
            output.appendBytes(type.getSlice(block, 0));
        } else if (type.getJavaType() == Boolean.TYPE) {
            output.appendByte(type.getBoolean(block, 0) ? 1 : 0);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
        }
    }

    @Override
    public void deserialize(Block block, int index, ArbitraryAggregationState state) {
        BasicSliceInput input = block.getSlice(index, 0, block.getLength(index)).getInput();
        int valueLength = input.readInt();
        state.setValue(null);
        if (valueLength > 0) {
            state.setValue(ArbitraryAggregationStateSerializer.toBlock(state.getType(), (SliceInput)input, valueLength));
        }
    }

    private static Block toBlock(Type type, SliceInput input, int length) {
        BlockBuilder builder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Long.TYPE) {
            type.writeLong(builder, input.readLong());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(builder, input.readDouble());
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(builder, input.readSlice(length));
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(builder, input.readByte() != 0);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type.getJavaType().getSimpleName());
        }
        return builder.build();
    }
}

