/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;

public class GenericAccumulatorFactoryBinder {
    private final boolean approximationSupported;
    private final AccumulatorStateSerializer<?> stateSerializer;
    private final AccumulatorStateFactory<?> stateFactory;
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;

    public GenericAccumulatorFactoryBinder(AccumulatorStateSerializer<?> stateSerializer, AccumulatorStateFactory<?> stateFactory, Class<? extends Accumulator> accumulatorClass, Class<? extends GroupedAccumulator> groupedAccumulatorClass, boolean approximationSupported) {
        this.stateSerializer = (AccumulatorStateSerializer)Preconditions.checkNotNull(stateSerializer, (Object)"stateSerializer is null");
        this.stateFactory = (AccumulatorStateFactory)Preconditions.checkNotNull(stateFactory, (Object)"stateFactory is null");
        this.approximationSupported = approximationSupported;
        try {
            this.accumulatorConstructor = accumulatorClass.getConstructor(AccumulatorStateSerializer.class, AccumulatorStateFactory.class, List.class, Optional.class, Optional.class, Double.TYPE);
            this.groupedAccumulatorConstructor = groupedAccumulatorClass.getConstructor(AccumulatorStateSerializer.class, AccumulatorStateFactory.class, List.class, Optional.class, Optional.class, Double.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public AccumulatorFactory bind(List<Integer> argumentChannels, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
        if (!this.approximationSupported) {
            Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"Approximate queries not supported");
            Preconditions.checkArgument((!sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
        }
        return new GenericAccumulatorFactory(this.stateSerializer, this.stateFactory, this.accumulatorConstructor, this.groupedAccumulatorConstructor, argumentChannels, maskChannel, sampleWeightChannel, confidence);
    }
}

