/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import java.util.List;

@AggregationFunction(value="approx_distinct")
public final class ApproximateCountDistinctAggregations {
    public static final InternalAggregationFunction LONG_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction DOUBLE_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    public static final InternalAggregationFunction VARBINARY_APPROXIMATE_COUNT_DISTINCT_AGGREGATIONS = new AggregationCompiler().generateAggregationFunction(ApproximateCountDistinctAggregations.class, (Type)BigintType.BIGINT, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE));
    private static final double DEFAULT_STANDARD_ERROR = 0.023;
    private static final double LOWEST_MAX_STANDARD_ERROR = 0.0115;
    private static final double HIGHEST_MAX_STANDARD_ERROR = 0.26;

    private ApproximateCountDistinctAggregations() {
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="bigint") long value) {
        ApproximateCountDistinctAggregations.input(state, value, 0.023);
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="bigint") long value, @SqlType(value="double") double maxStandardError) {
        HyperLogLog hll = ApproximateCountDistinctAggregations.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        hll.add(value);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="double") double value) {
        ApproximateCountDistinctAggregations.input(state, value, 0.023);
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="double") double value, @SqlType(value="double") double maxStandardError) {
        ApproximateCountDistinctAggregations.input(state, Double.doubleToLongBits(value), maxStandardError);
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="varchar") Slice value) {
        ApproximateCountDistinctAggregations.input(state, value, 0.023);
    }

    @InputFunction
    public static void input(HyperLogLogState state, @SqlType(value="varchar") Slice value, @SqlType(value="double") double maxStandardError) {
        HyperLogLog hll = ApproximateCountDistinctAggregations.getOrCreateHyperLogLog(state, maxStandardError);
        state.addMemoryUsage(-hll.estimatedInMemorySize());
        hll.add(value);
        state.addMemoryUsage(hll.estimatedInMemorySize());
    }

    private static HyperLogLog getOrCreateHyperLogLog(HyperLogLogState state, double maxStandardError) {
        HyperLogLog hll = state.getHyperLogLog();
        if (hll == null) {
            hll = HyperLogLog.newInstance((int)ApproximateCountDistinctAggregations.standardErrorToBuckets(maxStandardError));
            state.setHyperLogLog(hll);
            state.addMemoryUsage(hll.estimatedInMemorySize());
        }
        return hll;
    }

    @VisibleForTesting
    static int standardErrorToBuckets(double maxStandardError) {
        Failures.checkCondition(maxStandardError >= 0.0115 && maxStandardError <= 0.26, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Max standard error must be in [%s, %s]: %s", 0.0115, 0.26, maxStandardError);
        return ApproximateCountDistinctAggregations.log2Ceiling((int)Math.ceil(1.0816 / (maxStandardError * maxStandardError)));
    }

    private static int log2Ceiling(int value) {
        return Integer.highestOneBit(value - 1) << 1;
    }

    @CombineFunction
    public static void combineState(HyperLogLogState state, HyperLogLogState otherState) {
        HyperLogLog input = otherState.getHyperLogLog();
        HyperLogLog previous = state.getHyperLogLog();
        if (previous == null) {
            state.setHyperLogLog(input);
            state.addMemoryUsage(input.estimatedInMemorySize());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySize());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySize());
        }
    }

    @OutputFunction(value="bigint")
    public static void evaluateFinal(HyperLogLogState state, BlockBuilder out) {
        HyperLogLog hyperLogLog = state.getHyperLogLog();
        if (hyperLogLog == null) {
            BigintType.BIGINT.writeLong(out, 0L);
        } else {
            BigintType.BIGINT.writeLong(out, hyperLogLog.cardinality());
        }
    }
}

