/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.PageBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public abstract class Unnester
implements Closeable {
    protected static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    protected static final int ESTIMATED_JSON_OUTPUT_SIZE = 512;
    private final int channelCount;
    private final JsonParser jsonParser;
    private boolean closed;

    protected Unnester(int channelCount, @Nullable Slice slice) {
        this.channelCount = channelCount;
        if (slice == null) {
            this.jsonParser = null;
            return;
        }
        try {
            this.jsonParser = JSON_FACTORY.createJsonParser((InputStream)slice.getInput());
            JsonToken token = this.jsonParser.nextToken();
            Preconditions.checkState((token == JsonToken.START_ARRAY || token == JsonToken.START_OBJECT ? 1 : 0) != 0, (String)"Expected start of array or object in input: \"%s\"", (Object[])new Object[]{slice.toStringUtf8()});
            this.readNextToken();
        }
        catch (IOException e) {
            this.close();
            throw Throwables.propagate((Throwable)e);
        }
    }

    public final int getChannelCount() {
        return this.channelCount;
    }

    public final void appendNext(PageBuilder pageBuilder, int outputChannelOffset) {
        this.appendTo(pageBuilder, outputChannelOffset, this.jsonParser);
        this.readNextToken();
    }

    protected abstract void appendTo(PageBuilder var1, int var2, JsonParser var3);

    public final boolean hasNext() {
        return this.jsonParser != null && !this.closed;
    }

    protected final void readNextToken() {
        JsonToken token;
        Preconditions.checkNotNull((Object)this.jsonParser, (Object)"jsonParser is null");
        try {
            token = this.jsonParser.nextToken();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (token == null || token == JsonToken.END_ARRAY || token == JsonToken.END_OBJECT) {
            this.close();
        }
    }

    @Override
    public final void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.jsonParser != null) {
                this.jsonParser.close();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            this.closed = true;
        }
    }
}

