/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.RowComparator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class TopNOperator
implements Operator {
    private static final int MAX_INITIAL_PRIORITY_QUEUE_SIZE = 10000;
    private static final DataSize OVERHEAD_PER_VALUE = new DataSize(100.0, DataSize.Unit.BYTE);
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final int n;
    private final List<Type> sortTypes;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;
    private final TopNMemoryManager memoryManager;
    private final boolean partial;
    private final PageBuilder pageBuilder;
    private TopNBuilder topNBuilder;
    private boolean finishing;
    private Iterator<Block[]> outputIterator;

    public TopNOperator(OperatorContext operatorContext, List<Type> types, int n, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, boolean partial) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"n must be greater than zero");
        this.n = n;
        this.sortTypes = (List)Preconditions.checkNotNull(sortTypes, (Object)"sortTypes is null");
        this.sortChannels = (List)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        this.sortOrders = (List)Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        this.partial = partial;
        this.memoryManager = new TopNMemoryManager((OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null"));
        this.pageBuilder = new PageBuilder(types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.topNBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.topNBuilder == null || !this.topNBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.topNBuilder == null) {
            this.topNBuilder = new TopNBuilder(this.n, this.sortTypes, this.sortChannels, this.sortOrders, this.memoryManager);
        }
        Preconditions.checkState((!this.topNBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        this.topNBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.topNBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.topNBuilder.isFull()) {
                return null;
            }
            if (this.finishing || this.partial) {
                this.outputIterator = this.topNBuilder.build();
                this.topNBuilder = null;
            } else {
                throw new ExceededMemoryLimitException(this.memoryManager.getMaxMemorySize());
            }
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.outputIterator.hasNext()) {
            Block[] next = this.outputIterator.next();
            this.pageBuilder.declarePosition();
            for (int i = 0; i < next.length; ++i) {
                Type type = this.types.get(i);
                type.appendTo(next[i], 0, this.pageBuilder.getBlockBuilder(i));
            }
        }
        return this.pageBuilder.build();
    }

    public static class TopNMemoryManager {
        private final OperatorContext operatorContext;
        private long currentMemoryReservation;

        public TopNMemoryManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        public boolean canUse(long memorySize) {
            long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
            if (delta <= 0L) {
                return false;
            }
            if (!this.operatorContext.reserveMemory(delta)) {
                return true;
            }
            this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
            return false;
        }

        public DataSize getMaxMemorySize() {
            return this.operatorContext.getMaxMemorySize();
        }
    }

    private static class TopNBuilder {
        private final int n;
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final TopNMemoryManager memoryManager;
        private final PriorityQueue<Block[]> globalCandidates;
        private long memorySize;

        private TopNBuilder(int n, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders, TopNMemoryManager memoryManager) {
            this.n = n;
            this.sortTypes = sortTypes;
            this.sortChannels = sortChannels;
            this.sortOrders = sortOrders;
            this.memoryManager = memoryManager;
            Ordering comparator = Ordering.from((Comparator)new RowComparator(sortTypes, sortChannels, sortOrders)).reverse();
            this.globalCandidates = new PriorityQueue(Math.min(n, 10000), comparator);
        }

        public void processPage(Page page) {
            long sizeDelta = this.mergeWithGlobalCandidates(page);
            this.memorySize += sizeDelta;
        }

        private long mergeWithGlobalCandidates(Page page) {
            long sizeDelta = 0L;
            Block[] blocks = page.getBlocks();
            for (int position = 0; position < page.getPositionCount(); ++position) {
                if (this.globalCandidates.size() < this.n) {
                    sizeDelta += this.addRow(position, blocks);
                    continue;
                }
                if (this.compare(position, blocks, this.globalCandidates.peek()) >= 0) continue;
                sizeDelta += this.addRow(position, blocks);
            }
            return sizeDelta;
        }

        private int compare(int position, Block[] blocks, Block[] currentMax) {
            for (int i = 0; i < this.sortChannels.size(); ++i) {
                Block block;
                Block currentMaxValue;
                Type type = this.sortTypes.get(i);
                int sortChannel = this.sortChannels.get(i);
                SortOrder sortOrder = this.sortOrders.get(i);
                int compare = -sortOrder.compareBlockValue(type, currentMaxValue = currentMax[sortChannel], 0, block = blocks[sortChannel], position);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }

        private long addRow(int position, Block[] blocks) {
            long sizeDelta = 0L;
            Block[] row = TopNBuilder.getValues(position, blocks);
            sizeDelta += TopNBuilder.sizeOfRow(row);
            this.globalCandidates.add(row);
            while (this.globalCandidates.size() > this.n) {
                Block[] previous = (Block[])this.globalCandidates.remove();
                sizeDelta -= TopNBuilder.sizeOfRow(previous);
            }
            return sizeDelta;
        }

        private static long sizeOfRow(Block[] row) {
            long size = OVERHEAD_PER_VALUE.toBytes();
            for (Block value : row) {
                size += (long)value.getSizeInBytes();
            }
            return size;
        }

        private static Block[] getValues(int position, Block[] blocks) {
            Block[] row = new Block[blocks.length];
            for (int i = 0; i < blocks.length; ++i) {
                row[i] = blocks[i].getSingleValueBlock(position);
            }
            return row;
        }

        private boolean isFull() {
            return this.memoryManager.canUse(this.memorySize);
        }

        public Iterator<Block[]> build() {
            ImmutableList.Builder minSortedGlobalCandidates = ImmutableList.builder();
            while (!this.globalCandidates.isEmpty()) {
                Block[] row = (Block[])this.globalCandidates.remove();
                minSortedGlobalCandidates.add((Object)row);
            }
            return minSortedGlobalCandidates.build().reverse().iterator();
        }
    }

    public static class TopNOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final boolean partial;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, boolean partial) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.n = n;
            ImmutableList.Builder sortTypes = ImmutableList.builder();
            for (int channel : sortChannels) {
                sortTypes.add((Object)types.get(channel));
            }
            this.sortTypes = sortTypes.build();
            this.sortChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null")));
            this.sortOrders = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null")));
            this.partial = partial;
        }

        @Override
        public List<Type> getTypes() {
            return this.sourceTypes;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.sourceTypes, this.n, this.sortTypes, this.sortChannels, this.sortOrders, this.partial);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

