/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FinishedPageSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class TableScanOperator
implements SourceOperator,
Closeable {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final PageSourceProvider pageSourceProvider;
    private final List<Type> types;
    private final List<ColumnHandle> columns;
    private final SettableFuture<?> blocked;
    @GuardedBy(value="this")
    private ConnectorPageSource source;
    private long completedBytes;
    private long readTimeNanos;

    public TableScanOperator(OperatorContext operatorContext, PlanNodeId planNodeId, PageSourceProvider pageSourceProvider, List<Type> types, Iterable<ColumnHandle> columns) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        this.pageSourceProvider = (PageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceManager is null");
        this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        this.blocked = SettableFuture.create();
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkState((this.getSource() == null ? 1 : 0) != 0, (Object)"Table scan split already set");
        this.source = this.pageSourceProvider.createPageSource(split, this.columns);
        Object splitInfo = split.getInfo();
        if (splitInfo != null) {
            this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)splitInfo));
        }
        this.blocked.set(null);
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.source == null) {
            this.source = FinishedPageSource.FINISHED_PAGE_SOURCE;
        }
    }

    private synchronized ConnectorPageSource getSource() {
        return this.source;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public synchronized void close() {
        this.finish();
    }

    @Override
    public void finish() {
        ConnectorPageSource delegate = this.getSource();
        if (delegate == null) {
            return;
        }
        try {
            delegate.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isFinished() {
        ConnectorPageSource delegate = this.getSource();
        return delegate != null && delegate.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ConnectorPageSource delegate = this.getSource();
        if (delegate != null) {
            return NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        ConnectorPageSource delegate = this.getSource();
        if (delegate == null) {
            return null;
        }
        Page page = delegate.getNextPage();
        if (page != null) {
            page.assureLoaded();
            long endCompletedBytes = delegate.getCompletedBytes();
            long endReadTimeNanos = delegate.getReadTimeNanos();
            this.operatorContext.recordGeneratedInput(endCompletedBytes - this.completedBytes, page.getPositionCount(), endReadTimeNanos - this.readTimeNanos);
            this.completedBytes = endCompletedBytes;
            this.readTimeNanos = endReadTimeNanos;
        }
        return page;
    }

    public static class TableScanOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final PageSourceProvider pageSourceProvider;
        private final List<Type> types;
        private final List<ColumnHandle> columns;
        private boolean closed;

        public TableScanOperatorFactory(int operatorId, PlanNodeId sourceId, PageSourceProvider pageSourceProvider, List<Type> types, Iterable<ColumnHandle> columns) {
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
            this.pageSourceProvider = (PageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceManager is null");
            this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TableScanOperator.class.getSimpleName());
            return new TableScanOperator(operatorContext, this.sourceId, this.pageSourceProvider, this.types, this.columns);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

