/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class PageSourceOperator
implements Operator,
Closeable {
    private final ConnectorPageSource pageSource;
    private final List<Type> types;
    private final OperatorContext operatorContext;
    private long completedBytes;
    private long readTimeNanos;

    public PageSourceOperator(ConnectorPageSource pageSource, List<Type> types, OperatorContext operatorContext) {
        this.pageSource = (ConnectorPageSource)Preconditions.checkNotNull((Object)pageSource, (Object)"pageSource is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        try {
            this.pageSource.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.pageSource.isFinished();
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.pageSource.getNextPage();
        if (page == null) {
            return null;
        }
        long endCompletedBytes = this.pageSource.getCompletedBytes();
        long endReadTimeNanos = this.pageSource.getReadTimeNanos();
        this.operatorContext.recordGeneratedInput(endCompletedBytes - this.completedBytes, page.getPositionCount(), endReadTimeNanos - this.readTimeNanos);
        this.completedBytes = endCompletedBytes;
        this.readTimeNanos = endReadTimeNanos;
        return page;
    }

    @Override
    public void close() throws IOException {
        this.pageSource.close();
    }
}

