/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.MoreFutures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.List;

public class LookupJoinOperator
implements Operator,
Closeable {
    private final ListenableFuture<LookupSource> lookupSourceFuture;
    private final OperatorContext operatorContext;
    private final JoinProbeFactory joinProbeFactory;
    private final boolean enableOuterJoin;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private LookupSource lookupSource;
    private JoinProbe probe;
    private boolean finishing;
    private long joinPosition = -1L;

    public LookupJoinOperator(OperatorContext operatorContext, LookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes, boolean enableOuterJoin, JoinProbeFactory joinProbeFactory) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)lookupSourceSupplier, (Object)"lookupSourceSupplier is null");
        Preconditions.checkNotNull(probeTypes, (Object)"probeTypes is null");
        this.lookupSourceFuture = lookupSourceSupplier.getLookupSource(operatorContext);
        this.joinProbeFactory = joinProbeFactory;
        this.enableOuterJoin = enableOuterJoin;
        this.types = ImmutableList.builder().addAll(probeTypes).addAll(lookupSourceSupplier.getTypes()).build();
        this.pageBuilder = new PageBuilder(this.types);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.probe == null && this.pageBuilder.isEmpty();
        if (finished) {
            if (this.lookupSource != null) {
                this.lookupSource.close();
                this.lookupSource = null;
            }
            this.probe = null;
            this.pageBuilder.reset();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.lookupSourceFuture;
    }

    @Override
    public boolean needsInput() {
        if (this.finishing) {
            return false;
        }
        if (this.lookupSource == null) {
            this.lookupSource = MoreFutures.tryGetUnchecked(this.lookupSourceFuture);
        }
        return this.lookupSource != null && this.probe == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.lookupSource != null ? 1 : 0) != 0, (Object)"Lookup source has not been built yet");
        Preconditions.checkState((this.probe == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        this.probe = this.joinProbeFactory.createJoinProbe(this.lookupSource, page);
        this.joinPosition = -1L;
    }

    @Override
    public Page getOutput() {
        if (this.probe != null) {
            while (this.joinCurrentPosition() && this.advanceProbePosition() && this.outerJoinCurrentPosition()) {
            }
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty() && this.probe == null) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    @Override
    public void close() {
        if (this.lookupSource != null) {
            this.lookupSource.close();
            this.lookupSource = null;
        }
    }

    private boolean joinCurrentPosition() {
        while (this.joinPosition >= 0L) {
            this.pageBuilder.declarePosition();
            this.probe.appendTo(this.pageBuilder);
            this.lookupSource.appendTo(this.joinPosition, this.pageBuilder, this.probe.getChannelCount());
            this.joinPosition = this.lookupSource.getNextJoinPosition(this.joinPosition);
            if (!this.pageBuilder.isFull()) continue;
            return false;
        }
        return true;
    }

    private boolean advanceProbePosition() {
        if (!this.probe.advanceNextPosition()) {
            this.probe = null;
            return false;
        }
        this.joinPosition = this.probe.getCurrentJoinPosition();
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (this.enableOuterJoin && this.joinPosition < 0L) {
            this.pageBuilder.declarePosition();
            this.probe.appendTo(this.pageBuilder);
            int outputIndex = this.probe.getChannelCount();
            for (int buildChannel = 0; buildChannel < this.lookupSource.getChannelCount(); ++buildChannel) {
                this.pageBuilder.getBlockBuilder(outputIndex).appendNull();
                ++outputIndex;
            }
            if (this.pageBuilder.isFull()) {
                return false;
            }
        }
        return true;
    }
}

