/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import io.airlift.slice.XxHash64;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class GroupByHash {
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler();
    private static final float FILL_RATIO = 0.75f;
    private final List<Type> types;
    private final int[] channels;
    private final PagesHashStrategy hashStrategy;
    private final List<ObjectArrayList<Block>> channelBuilders;
    private final HashGenerator hashGenerator;
    private final Optional<Integer> precomputedHashChannel;
    private PageBuilder currentPageBuilder;
    private long completedPagesMemorySize;
    private int maxFill;
    private int mask;
    private long[] key;
    private int[] value;
    private final LongBigArray groupAddress;
    private int nextGroupId;

    public GroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize) {
        Preconditions.checkNotNull(hashTypes, (Object)"hashTypes is null");
        Preconditions.checkArgument((hashTypes.size() == hashChannels.length ? 1 : 0) != 0, (Object)"hashTypes and hashChannels have different sizes");
        Preconditions.checkNotNull(inputHashChannel, (Object)"inputHashChannel is null");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.types = inputHashChannel.isPresent() ? ImmutableList.copyOf((Iterable)Iterables.concat(hashTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))) : ImmutableList.copyOf(hashTypes);
        this.channels = (int[])((int[])Preconditions.checkNotNull((Object)hashChannels, (Object)"hashChannels is null")).clone();
        this.hashGenerator = inputHashChannel.isPresent() ? new PrecomputedHashGenerator(inputHashChannel.get()) : new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        ImmutableList.Builder outputChannels = ImmutableList.builder();
        ImmutableList.Builder channelBuilders = ImmutableList.builder();
        for (int i = 0; i < hashChannels.length; ++i) {
            outputChannels.add((Object)i);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        }
        if (inputHashChannel.isPresent()) {
            this.precomputedHashChannel = Optional.of(hashChannels.length);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        } else {
            this.precomputedHashChannel = Optional.empty();
        }
        this.channelBuilders = channelBuilders.build();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = JOIN_COMPILER.compilePagesHashStrategyFactory(this.types, (List<Integer>)outputChannels.build());
        this.hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy(this.channelBuilders, this.precomputedHashChannel);
        this.startNewPage();
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = HashCommon.maxFill((int)hashSize, (float)0.75f);
        this.mask = hashSize - 1;
        this.key = new long[hashSize];
        Arrays.fill(this.key, -1L);
        this.value = new int[hashSize];
        this.groupAddress = new LongBigArray();
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    public long getEstimatedSize() {
        return SizeOf.sizeOf((Object[])this.channelBuilders.get(0).elements()) * (long)this.channelBuilders.size() + this.completedPagesMemorySize + this.currentPageBuilder.getSizeInBytes() + SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((int[])this.value) + this.groupAddress.sizeOf();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getGroupCount() {
        return this.nextGroupId;
    }

    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        long address = this.groupAddress.get(groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        this.hashStrategy.appendTo(blockIndex, position, pageBuilder, outputChannelOffset);
    }

    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Block[] hashBlocks = new Block[this.channels.length];
        for (int i = 0; i < this.channels.length; ++i) {
            hashBlocks[i] = page.getBlock(this.channels[i]);
        }
        for (int position = 0; position < positionCount; ++position) {
            int groupId = this.putIfAbsent(position, page, hashBlocks);
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        return new GroupByIdBlock(this.nextGroupId, blockBuilder.build());
    }

    public boolean contains(int position, Page page) {
        return this.contains(position, page, this.hashStrategy.hashRow(position, page.getBlocks()));
    }

    public boolean contains(int position, Page page, int rawHash) {
        int hashPosition = GroupByHash.getHashPosition(rawHash, this.mask);
        while (this.key[hashPosition] != -1L) {
            long address = this.key[hashPosition];
            if (this.hashStrategy.positionEqualsRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, page.getBlocks())) {
                return true;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        return false;
    }

    public int putIfAbsent(int position, Page page, Block[] hashBlocks) {
        int rawHash = this.hashGenerator.hashPosition(position, page);
        int hashPosition = GroupByHash.getHashPosition(rawHash, this.mask);
        int groupId = -1;
        while (this.key[hashPosition] != -1L) {
            long address = this.key[hashPosition];
            if (this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, hashBlocks)) {
                groupId = this.value[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, position, page, rawHash);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, int position, Page page, int rawHash) {
        Block[] blocks = page.getBlocks();
        for (int i = 0; i < this.channels.length; ++i) {
            int hashChannel = this.channels[i];
            Type type = this.types.get(i);
            type.appendTo(blocks[hashChannel], position, this.currentPageBuilder.getBlockBuilder(i));
        }
        if (this.precomputedHashChannel.isPresent()) {
            BigintType.BIGINT.writeLong(this.currentPageBuilder.getBlockBuilder(this.precomputedHashChannel.get().intValue()), (long)rawHash);
        }
        this.currentPageBuilder.declarePosition();
        int pageIndex = this.channelBuilders.get(0).size() - 1;
        int pagePosition = this.currentPageBuilder.getPositionCount() - 1;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pagePosition);
        int groupId = this.nextGroupId++;
        this.key[hashPosition] = address;
        this.value[hashPosition] = groupId;
        this.groupAddress.set(groupId, address);
        if (this.currentPageBuilder.isFull()) {
            this.startNewPage();
        }
        if (this.nextGroupId >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return groupId;
    }

    private void startNewPage() {
        if (this.currentPageBuilder != null) {
            this.completedPagesMemorySize += this.currentPageBuilder.getSizeInBytes();
        }
        this.currentPageBuilder = new PageBuilder(this.types);
        for (int i = 0; i < this.types.size(); ++i) {
            this.channelBuilders.get(i).add((Object)this.currentPageBuilder.getBlockBuilder(i));
        }
    }

    private void rehash(int size) {
        int newSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        int newMask = newSize - 1;
        long[] newKey = new long[newSize];
        Arrays.fill(newKey, -1L);
        int[] newValue = new int[newSize];
        int oldIndex = 0;
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            while (this.key[oldIndex] == -1L) {
                ++oldIndex;
            }
            long address = this.key[oldIndex];
            int pos = GroupByHash.getHashPosition(this.hashPosition(address), newMask);
            while (newKey[pos] != -1L) {
                pos = pos + 1 & newMask;
            }
            newKey[pos] = address;
            newValue[pos] = this.value[oldIndex];
            ++oldIndex;
        }
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill((int)newSize, (float)0.75f);
        this.key = newKey;
        this.value = newValue;
        this.groupAddress.ensureCapacity(this.maxFill);
    }

    private int hashPosition(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        int position = SyntheticAddress.decodePosition(sliceAddress);
        if (this.precomputedHashChannel.isPresent()) {
            return this.getRawHash(sliceIndex, position);
        }
        return this.hashStrategy.hashPosition(sliceIndex, position);
    }

    private int getRawHash(int sliceIndex, int position) {
        return (int)((Block)this.channelBuilders.get(this.precomputedHashChannel.get()).get(sliceIndex)).getLong(position, 0);
    }

    private boolean positionEqualsCurrentRow(int sliceIndex, int slicePosition, int position, Block[] blocks) {
        return this.hashStrategy.positionEqualsRow(sliceIndex, slicePosition, position, blocks);
    }

    private static int getHashPosition(int rawHash, int mask) {
        return (int)XxHash64.hash((long)rawHash) & mask;
    }
}

