/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class GenericPageProcessor
implements PageProcessor {
    private final FilterFunction filterFunction;
    private final List<ProjectionFunction> projections;

    public GenericPageProcessor(FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
        this.filterFunction = filterFunction;
        this.projections = ImmutableList.copyOf(projections);
    }

    @Override
    public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
        int position;
        for (position = start; position < end && !pageBuilder.isFull(); ++position) {
            if (!this.filterFunction.filter(position, page.getBlocks())) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(position, page.getBlocks(), pageBuilder.getBlockBuilder(i));
            }
        }
        return position;
    }
}

