/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class FilterAndProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private final PageProcessor processor;
    private Page currentPage;
    private int currentPosition;
    private boolean finishing;

    public FilterAndProjectOperator(OperatorContext operatorContext, Iterable<? extends Type> types, PageProcessor processor) {
        this.processor = (PageProcessor)Preconditions.checkNotNull((Object)processor, (Object)"processor is null");
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty() && this.currentPage == null;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull() && this.currentPage == null;
    }

    @Override
    public final void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        this.currentPage = page;
        this.currentPosition = 0;
    }

    @Override
    public final Page getOutput() {
        if (!this.pageBuilder.isFull() && this.currentPage != null) {
            this.currentPosition = this.processor.process(this.operatorContext.getSession().toConnectorSession(), this.currentPage, this.currentPosition, this.currentPage.getPositionCount(), this.pageBuilder);
            if (this.currentPosition == this.currentPage.getPositionCount()) {
                this.currentPage = null;
                this.currentPosition = 0;
            }
        }
        if (!this.finishing && !this.pageBuilder.isFull() || this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    public static class FilterAndProjectOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PageProcessor processor;
        private final List<Type> types;
        private boolean closed;

        public FilterAndProjectOperatorFactory(int operatorId, PageProcessor processor, List<Type> types) {
            this.operatorId = operatorId;
            this.processor = processor;
            this.types = types;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, FilterAndProjectOperator.class.getSimpleName());
            return new FilterAndProjectOperator(operatorContext, this.types, this.processor);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

