/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class DistinctLimitOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private Page outputPage;
    private long remainingLimit;
    private boolean finishing;
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public DistinctLimitOperator(OperatorContext operatorContext, List<Type> types, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        Preconditions.checkNotNull(distinctChannels, (Object)"distinctChannels is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
        Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
        ImmutableList.Builder distinctTypes = ImmutableList.builder();
        for (int channel : distinctChannels) {
            distinctTypes.add((Object)types.get(channel));
        }
        this.groupByHash = new GroupByHash((List<? extends Type>)distinctTypes.build(), Ints.toArray(distinctChannels), hashChannel, Math.min((int)limit, 10000));
        this.pageBuilder = new PageBuilder(types);
        this.remainingLimit = limit;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
        this.pageBuilder.reset();
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.outputPage == null || this.remainingLimit == 0L && this.outputPage == null;
    }

    @Override
    public boolean needsInput() {
        this.operatorContext.setMemoryReservation(this.groupByHash.getEstimatedSize());
        return !this.finishing && this.remainingLimit > 0L && this.outputPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((boolean)this.needsInput());
        this.operatorContext.setMemoryReservation(this.groupByHash.getEstimatedSize());
        this.pageBuilder.reset();
        GroupByIdBlock ids = this.groupByHash.getGroupIds(page);
        for (int position = 0; position < ids.getPositionCount(); ++position) {
            if (ids.getGroupId(position) != this.nextDistinctId) continue;
            this.pageBuilder.declarePosition();
            for (int channel = 0; channel < this.types.size(); ++channel) {
                Type type = this.types.get(channel);
                type.appendTo(page.getBlock(channel), position, this.pageBuilder.getBlockBuilder(channel));
            }
            --this.remainingLimit;
            ++this.nextDistinctId;
            if (this.remainingLimit == 0L) break;
        }
        if (!this.pageBuilder.isEmpty()) {
            this.outputPage = this.pageBuilder.build();
        }
    }

    @Override
    public Page getOutput() {
        Page result = this.outputPage;
        this.outputPage = null;
        return result;
    }

    public static class DistinctLimitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Integer> distinctChannels;
        private final List<Type> types;
        private final long limit;
        private final Optional<Integer> hashChannel;
        private boolean closed;

        public DistinctLimitOperatorFactory(int operatorId, List<? extends Type> types, List<Integer> distinctChannels, long limit, Optional<Integer> hashChannel) {
            this.operatorId = operatorId;
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.distinctChannels = (List)Preconditions.checkNotNull(distinctChannels, (Object)"distinctChannels is null");
            Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be at least zero");
            this.limit = limit;
            this.hashChannel = (Optional)Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, DistinctLimitOperator.class.getSimpleName());
            return new DistinctLimitOperator(operatorContext, this.types, this.distinctChannels, this.limit, this.hashChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

