/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class ChannelSet {
    private final GroupByHash hash;
    private final boolean containsNull;

    public ChannelSet(GroupByHash hash, boolean containsNull) {
        this.hash = hash;
        this.containsNull = containsNull;
    }

    public Type getType() {
        return this.hash.getTypes().get(0);
    }

    public long getEstimatedSizeInBytes() {
        return this.hash.getEstimatedSize();
    }

    public int size() {
        return this.hash.getGroupCount();
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public boolean contains(int position, Page page, Block hashBlock) {
        int rawHash = (int)BigintType.BIGINT.getLong(hashBlock, position);
        return this.hash.contains(position, page, rawHash);
    }

    public boolean contains(int position, Page page) {
        return this.hash.contains(position, page);
    }

    public static class ChannelSetBuilder {
        private final GroupByHash hash;
        private final OperatorContext operatorContext;
        private final Page nullBlockPage;

        public ChannelSetBuilder(Type type, Optional<Integer> hashChannel, int expectedPositions, OperatorContext operatorContext) {
            ImmutableList types = ImmutableList.of((Object)type);
            this.hash = new GroupByHash((List<? extends Type>)types, new int[]{0}, hashChannel, expectedPositions);
            this.operatorContext = operatorContext;
            this.nullBlockPage = new Page(new Block[]{type.createBlockBuilder(new BlockBuilderStatus()).appendNull().build()});
        }

        public ChannelSet build() {
            return new ChannelSet(this.hash, this.hash.contains(0, this.nullBlockPage));
        }

        public long getEstimatedSize() {
            return this.hash.getEstimatedSize();
        }

        public int size() {
            return this.hash.getGroupCount();
        }

        public void addPage(Page page) {
            this.hash.getGroupIds(page);
            if (this.operatorContext != null) {
                this.operatorContext.setMemoryReservation(this.hash.getEstimatedSize());
            }
        }
    }
}

