/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;

public class PrestoNode
implements Node {
    private final String nodeIdentifier;
    private final URI httpUri;
    private final NodeVersion nodeVersion;

    public PrestoNode(String nodeIdentifier, URI httpUri, NodeVersion nodeVersion) {
        nodeIdentifier = Strings.emptyToNull((String)Strings.nullToEmpty((String)nodeIdentifier).trim());
        this.nodeIdentifier = (String)Preconditions.checkNotNull((Object)nodeIdentifier, (Object)"nodeIdentifier is null or empty");
        this.httpUri = (URI)Preconditions.checkNotNull((Object)httpUri, (Object)"httpUri is null");
        this.nodeVersion = (NodeVersion)Preconditions.checkNotNull((Object)nodeVersion, (Object)"nodeVersion is null");
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public HostAddress getHostAndPort() {
        return HostAddress.fromUri((URI)this.httpUri);
    }

    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoNode o = (PrestoNode)obj;
        return this.nodeIdentifier.equals(o.nodeIdentifier);
    }

    public int hashCode() {
        return this.nodeIdentifier.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("httpUri", (Object)this.httpUri).add("nodeVersion", (Object)this.nodeVersion).toString();
    }
}

