/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class PartitionResult {
    private final List<Partition> partitions;
    private final TupleDomain<ColumnHandle> undeterminedTupleDomain;

    public PartitionResult(String connectorId, ConnectorPartitionResult connectorPartitionResult) {
        Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        Preconditions.checkNotNull((Object)connectorPartitionResult, (Object)"connectorPartitionResult is null");
        this.partitions = Lists.transform((List)connectorPartitionResult.getPartitions(), partition -> new Partition(connectorId, (ConnectorPartition)partition));
        this.undeterminedTupleDomain = Util.fromConnectorDomain(connectorId, (TupleDomain<ConnectorColumnHandle>)connectorPartitionResult.getUndeterminedTupleDomain());
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public TupleDomain<ColumnHandle> getUndeterminedTupleDomain() {
        return this.undeterminedTupleDomain;
    }
}

