/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;

public class Partition {
    private final String connectorId;
    private final ConnectorPartition connectorPartition;
    private final TupleDomain<ColumnHandle> columnHandleTupleDomain;

    public Partition(String connectorId, ConnectorPartition connectorPartition) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.connectorPartition = (ConnectorPartition)Preconditions.checkNotNull((Object)connectorPartition, (Object)"partition is null");
        this.columnHandleTupleDomain = Util.fromConnectorDomain(connectorId, (TupleDomain<ConnectorColumnHandle>)connectorPartition.getTupleDomain());
    }

    public ConnectorPartition getConnectorPartition() {
        return this.connectorPartition;
    }

    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.columnHandleTupleDomain;
    }

    public String toString() {
        return this.connectorId + ":" + this.connectorPartition;
    }
}

