/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.index;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IndexManager {
    private final ConcurrentMap<String, ConnectorIndexResolver> resolvers = new ConcurrentHashMap<String, ConnectorIndexResolver>();

    public void addIndexResolver(String connectorId, ConnectorIndexResolver resolver) {
        Preconditions.checkState((this.resolvers.putIfAbsent(connectorId, resolver) == null ? 1 : 0) != 0, (String)"IndexResolver for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public Optional<ResolvedIndex> resolveIndex(TableHandle tableHandle, Set<ColumnHandle> indexableColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ConnectorIndexResolver resolver = (ConnectorIndexResolver)this.resolvers.get(tableHandle.getConnectorId());
        if (resolver == null) {
            return Optional.empty();
        }
        ImmutableSet columns = ImmutableSet.copyOf((Iterable)Iterables.transform(indexableColumns, ColumnHandle::getConnectorHandle));
        ConnectorResolvedIndex resolved = resolver.resolveIndex(tableHandle.getConnectorHandle(), (Set)columns, Util.toConnectorDomain(tupleDomain));
        if (resolved == null) {
            return Optional.empty();
        }
        return Optional.of(new ResolvedIndex(tableHandle.getConnectorId(), resolved));
    }

    public Index getIndex(IndexHandle indexHandle, List<ColumnHandle> lookupSchema, List<ColumnHandle> outputSchema) {
        return this.getResolver(indexHandle).getIndex(indexHandle.getConnectorHandle(), Lists.transform(lookupSchema, ColumnHandle::getConnectorHandle), Lists.transform(outputSchema, ColumnHandle::getConnectorHandle));
    }

    private ConnectorIndexResolver getResolver(IndexHandle handle) {
        ConnectorIndexResolver result = (ConnectorIndexResolver)this.resolvers.get(handle.getConnectorId());
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No index resolver for connector '%s'", (Object[])new Object[]{handle.getConnectorId()});
        return result;
    }
}

