/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.spi.StandardErrorCode;
import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlQueryManagerStats {
    private final CounterStat startedQueries = new CounterStat();
    private final CounterStat completedQueries = new CounterStat();
    private final CounterStat failedQueries = new CounterStat();
    private final CounterStat abandonedQueries = new CounterStat();
    private final CounterStat canceledQueries = new CounterStat();
    private final CounterStat userErrorFailures = new CounterStat();
    private final CounterStat internalFailures = new CounterStat();
    private final CounterStat externalFailures = new CounterStat();
    private final CounterStat insufficientResourcesFailures = new CounterStat();
    private final TimeStat executionTime = new TimeStat(TimeUnit.MILLISECONDS);
    private final DistributionStat wallInputBytesRate = new DistributionStat();
    private final DistributionStat cpuInputByteRate = new DistributionStat();

    public void queryStarted() {
        this.startedQueries.update(1L);
    }

    public void queryFinished(QueryInfo info) {
        long executionCpuMillis;
        this.completedQueries.update(1L);
        long rawInputBytes = info.getQueryStats().getRawInputDataSize().toBytes();
        long executionWallMillis = info.getQueryStats().getEndTime().getMillis() - info.getQueryStats().getCreateTime().getMillis();
        this.executionTime.add((double)executionWallMillis, TimeUnit.MILLISECONDS);
        if (executionWallMillis > 0L) {
            this.wallInputBytesRate.add(rawInputBytes * 1000L / executionWallMillis);
        }
        if ((executionCpuMillis = info.getQueryStats().getTotalCpuTime().toMillis()) > 0L) {
            this.cpuInputByteRate.add(rawInputBytes * 1000L / executionCpuMillis);
        }
        if (info.getErrorCode() != null) {
            switch (StandardErrorCode.toErrorType((int)info.getErrorCode().getCode())) {
                case USER_ERROR: {
                    this.userErrorFailures.update(1L);
                    break;
                }
                case INTERNAL_ERROR: {
                    this.internalFailures.update(1L);
                    break;
                }
                case INSUFFICIENT_RESOURCES: {
                    this.insufficientResourcesFailures.update(1L);
                    break;
                }
                case EXTERNAL: {
                    this.externalFailures.update(1L);
                }
            }
            if (info.getErrorCode().getCode() == StandardErrorCode.ABANDONED_QUERY.toErrorCode().getCode()) {
                this.abandonedQueries.update(1L);
            } else if (info.getErrorCode().getCode() == StandardErrorCode.USER_CANCELED.toErrorCode().getCode()) {
                this.canceledQueries.update(1L);
            }
            this.failedQueries.update(1L);
        }
    }

    @Managed
    public long getRunningQueries() {
        return Math.max(0L, this.startedQueries.getTotalCount() - this.completedQueries.getTotalCount());
    }

    @Managed
    @Nested
    public CounterStat getStartedQueries() {
        return this.startedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCompletedQueries() {
        return this.completedQueries;
    }

    @Managed
    @Nested
    public CounterStat getFailedQueries() {
        return this.failedQueries;
    }

    @Managed
    @Nested
    public TimeStat getExecutionTime() {
        return this.executionTime;
    }

    @Managed
    @Nested
    public CounterStat getUserErrorFailures() {
        return this.userErrorFailures;
    }

    @Managed
    @Nested
    public CounterStat getInternalFailures() {
        return this.internalFailures;
    }

    @Managed
    @Nested
    public CounterStat getAbandonedQueries() {
        return this.abandonedQueries;
    }

    @Managed
    @Nested
    public CounterStat getCanceledQueries() {
        return this.canceledQueries;
    }

    @Managed
    @Nested
    public CounterStat getExternalFailures() {
        return this.externalFailures;
    }

    @Managed
    @Nested
    public CounterStat getInsufficientResourcesFailures() {
        return this.insufficientResourcesFailures;
    }

    @Managed(description="Distribution of query input data rates (wall)")
    @Nested
    public DistributionStat getWallInputBytesRate() {
        return this.wallInputBytesRate;
    }

    @Managed(description="Distribution of query input data rates (cpu)")
    @Nested
    public DistributionStat getCpuInputByteRate() {
        return this.cpuInputByteRate;
    }
}

