/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.AbandonedException;
import com.facebook.presto.execution.FailedQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.AsyncSemaphore;
import io.airlift.concurrent.SetThreadName;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final SqlParser sqlParser;
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final QueryStarter queryStarter;
    private final int maxQueryHistory;
    private final Duration maxQueryAge;
    private final ConcurrentMap<QueryId, QueryExecution> queries = new ConcurrentHashMap<QueryId, QueryExecution>();
    private final Queue<QueryExecution> expirationQueue = new LinkedBlockingQueue<QueryExecution>();
    private final Duration clientTimeout;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final QueryIdGenerator queryIdGenerator;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final SqlQueryManagerStats stats = new SqlQueryManagerStats();

    @Inject
    public SqlQueryManager(SqlParser sqlParser, QueryManagerConfig config, QueryMonitor queryMonitor, QueryIdGenerator queryIdGenerator, LocationFactory locationFactory, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories) {
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.executionFactories = (Map)Preconditions.checkNotNull(executionFactories, (Object)"executionFactories is null");
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%d"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.queryStarter = new QueryStarter(this.queryExecutor, this.stats, config);
        this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
        this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        this.queryIdGenerator = (QueryIdGenerator)Preconditions.checkNotNull((Object)queryIdGenerator, (Object)"queryIdGenerator is null");
        this.maxQueryAge = config.getMaxQueryAge();
        this.maxQueryHistory = config.getMaxQueryHistory();
        this.clientTimeout = config.getClientTimeout();
        this.queryManagementExecutor = Executors.newScheduledThreadPool(config.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%d"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryManagementExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlQueryManager.this.failAbandonedQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error cancelling abandoned queries");
                }
                try {
                    SqlQueryManager.this.removeExpiredQueries();
                }
                catch (Throwable e) {
                    log.warn(e, "Error removing expired queries");
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<QueryInfo> getAllQueryInfo() {
        return (List)this.queries.values().stream().map(queryExecution -> {
            try {
                return queryExecution.getQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public Duration waitForStateChange(QueryId queryId, QueryState currentState, Duration maxWait) throws InterruptedException {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            return maxWait;
        }
        query.recordHeartbeat();
        return query.waitForStateChange(currentState, maxWait);
    }

    @Override
    public QueryInfo getQueryInfo(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query == null) {
            throw new NoSuchElementException();
        }
        query.recordHeartbeat();
        return query.getQueryInfo();
    }

    @Override
    public QueryInfo createQuery(Session session, String query) {
        Statement statement;
        Preconditions.checkNotNull((Object)query, (Object)"query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        try {
            statement = this.sqlParser.createStatement(query);
        }
        catch (ParsingException e) {
            return this.createFailedQuery(session, query, queryId, e);
        }
        QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(statement.getClass());
        Preconditions.checkState((queryExecutionFactory != null ? 1 : 0) != 0, (String)"Unsupported statement type %s", (Object[])new Object[]{statement.getClass().getName()});
        final Object queryExecution = queryExecutionFactory.createQueryExecution(queryId, query, session, statement);
        this.queryMonitor.createdEvent(queryExecution.getQueryInfo());
        queryExecution.addStateChangeListener(new StateMachine.StateChangeListener<QueryState>(){

            @Override
            public void stateChanged(QueryState newValue) {
                if (newValue.isDone()) {
                    QueryInfo info = queryExecution.getQueryInfo();
                    SqlQueryManager.this.stats.queryFinished(info);
                    SqlQueryManager.this.queryMonitor.completionEvent(info);
                    SqlQueryManager.this.expirationQueue.add(queryExecution);
                }
            }
        });
        this.queries.put(queryId, (QueryExecution)queryExecution);
        if (!this.queryStarter.submit((QueryExecution)queryExecution)) {
            return this.createFailedQuery(session, query, queryId, (Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, "Too many queued queries!"));
        }
        return queryExecution.getQueryInfo();
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        Preconditions.checkNotNull((Object)queryId, (Object)"queryId is null");
        log.debug("Cancel query %s", new Object[]{queryId});
        QueryExecution query = (QueryExecution)this.queries.get(queryId);
        if (query != null) {
            query.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled"));
        }
    }

    @Override
    public void cancelStage(StageId stageId) {
        Preconditions.checkNotNull((Object)stageId, (Object)"stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        QueryExecution query = (QueryExecution)this.queries.get(stageId.getQueryId());
        if (query != null) {
            query.cancelStage(stageId);
        }
    }

    @Managed
    public int getQueryQueueSize() {
        return this.queryStarter.getQueryQueueSize();
    }

    @Managed
    public int getBigQueryQueueSize() {
        return this.queryStarter.getBigQueryQueueSize();
    }

    @Managed
    @Flatten
    public SqlQueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    public void removeExpiredQueries() {
        DateTime timeHorizon = DateTime.now().minus(this.maxQueryAge.toMillis());
        while (this.expirationQueue.size() > this.maxQueryHistory) {
            QueryInfo queryInfo = this.expirationQueue.peek().getQueryInfo();
            if (queryInfo.getQueryStats().getEndTime().isAfter((ReadableInstant)timeHorizon)) {
                return;
            }
            QueryId queryId = queryInfo.getQueryId();
            log.debug("Remove query %s", new Object[]{queryId});
            this.queries.remove(queryId);
            this.expirationQueue.remove();
        }
    }

    public void failAbandonedQueries() {
        for (QueryExecution queryExecution : this.queries.values()) {
            QueryInfo queryInfo = queryExecution.getQueryInfo();
            if (queryInfo.getState().isDone() || !this.isAbandoned(queryExecution)) continue;
            log.info("Failing abandoned query %s", new Object[]{queryExecution.getQueryInfo().getQueryId()});
            queryExecution.fail((Throwable)((Object)new AbandonedException("Query " + queryInfo.getQueryId(), queryInfo.getQueryStats().getLastHeartbeat(), DateTime.now())));
        }
    }

    private boolean isAbandoned(QueryExecution query) {
        DateTime oldestAllowedHeartbeat = DateTime.now().minus(this.clientTimeout.toMillis());
        DateTime lastHeartbeat = query.getQueryInfo().getQueryStats().getLastHeartbeat();
        return lastHeartbeat != null && lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat);
    }

    private QueryInfo createFailedQuery(Session session, String query, QueryId queryId, Throwable cause) {
        URI self = this.locationFactory.createQueryLocation(queryId);
        FailedQueryExecution execution = new FailedQueryExecution(queryId, query, session, self, this.queryExecutor, cause);
        this.queries.put(queryId, execution);
        this.stats.queryStarted();
        this.queryMonitor.createdEvent(execution.getQueryInfo());
        this.queryMonitor.completionEvent(execution.getQueryInfo());
        this.stats.queryFinished(execution.getQueryInfo());
        this.expirationQueue.add(execution);
        return execution.getQueryInfo();
    }

    private static void addCompletionCallback(QueryExecution queryExecution, Runnable callback) {
        AtomicBoolean taskExecuted = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            if (newValue.isDone() && taskExecuted.compareAndSet(false, true)) {
                callback.run();
            }
        });
        if (queryExecution.getQueryInfo().getState().isDone() && taskExecuted.compareAndSet(false, true)) {
            callback.run();
        }
    }

    @ThreadSafe
    private static class QueryStarter {
        private final QueryQueue queryQueue;
        private final QueryQueue bigQueryQueue;

        public QueryStarter(Executor queryExecutor, SqlQueryManagerStats stats, QueryManagerConfig config) {
            Preconditions.checkNotNull((Object)queryExecutor, (Object)"queryExecutor is null");
            Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
            Preconditions.checkNotNull((Object)config, (Object)"config is null");
            this.queryQueue = new QueryQueue(queryExecutor, stats, config.getMaxQueuedQueries(), config.getMaxConcurrentQueries());
            this.bigQueryQueue = new QueryQueue(queryExecutor, stats, config.getMaxQueuedBigQueries(), config.getMaxConcurrentBigQueries());
        }

        public boolean submit(QueryExecution queryExecution) {
            if (SystemSessionProperties.isBigQueryEnabled(queryExecution.getQueryInfo().getSession(), false)) {
                return this.bigQueryQueue.enqueue(queryExecution);
            }
            return this.queryQueue.enqueue(queryExecution);
        }

        public int getQueryQueueSize() {
            return this.queryQueue.getQueueSize();
        }

        public int getBigQueryQueueSize() {
            return this.bigQueryQueue.getQueueSize();
        }

        private static class QueryQueue {
            private final int maxQueuedQueries;
            private final AtomicInteger queryQueueSize = new AtomicInteger();
            private final AsyncSemaphore<QueueEntry> asyncSemaphore;

            private QueryQueue(Executor queryExecutor, SqlQueryManagerStats stats, int maxQueuedQueries, int maxConcurrentQueries) {
                Preconditions.checkNotNull((Object)queryExecutor, (Object)"queryExecutor is null");
                Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
                Preconditions.checkArgument((maxQueuedQueries > 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries must be greater than zero");
                Preconditions.checkArgument((maxConcurrentQueries > 0 ? 1 : 0) != 0, (Object)"maxConcurrentQueries must be greater than zero");
                this.maxQueuedQueries = maxQueuedQueries;
                this.asyncSemaphore = new AsyncSemaphore(maxConcurrentQueries, queryExecutor, queueEntry -> {
                    QueryExecution queryExecution = queueEntry.dequeue();
                    if (queryExecution == null) {
                        return Futures.immediateFuture(null);
                    }
                    SettableFuture settableFuture = SettableFuture.create();
                    SqlQueryManager.addCompletionCallback(queryExecution, () -> settableFuture.set(null));
                    if (!settableFuture.isDone()) {
                        queryExecutor.execute(() -> {
                            try (SetThreadName setThreadName = new SetThreadName("Query-%s", new Object[]{queryExecution.getQueryInfo().getQueryId()});){
                                stats.queryStarted();
                                queryExecution.start();
                            }
                        });
                    }
                    return settableFuture;
                });
            }

            public int getQueueSize() {
                return this.queryQueueSize.get();
            }

            public boolean enqueue(QueryExecution queryExecution) {
                if (this.queryQueueSize.incrementAndGet() > this.maxQueuedQueries) {
                    this.queryQueueSize.decrementAndGet();
                    return false;
                }
                QueueEntry queueEntry = new QueueEntry(queryExecution, aVoid -> this.queryQueueSize.decrementAndGet());
                SqlQueryManager.addCompletionCallback(queryExecution, queueEntry::dequeue);
                this.asyncSemaphore.submit((Object)queueEntry);
                return true;
            }

            private static class QueueEntry {
                private final AtomicBoolean dequeued = new AtomicBoolean();
                private final AtomicReference<QueryExecution> queryExecution;
                private final Consumer<Void> onDequeue;

                private QueueEntry(QueryExecution queryExecution, Consumer<Void> onDequeue) {
                    Preconditions.checkNotNull((Object)queryExecution, (Object)"queryExecution is null");
                    Preconditions.checkNotNull(onDequeue, (Object)"onDequeue is null");
                    this.queryExecution = new AtomicReference<QueryExecution>(queryExecution);
                    this.onDequeue = onDequeue;
                }

                public QueryExecution dequeue() {
                    if (this.dequeued.compareAndSet(false, true)) {
                        this.onDequeue.accept(null);
                    }
                    return this.queryExecution.getAndSet(null);
                }
            }
        }
    }
}

