/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SimpleMarker;
import com.facebook.presto.spi.Range;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleRange {
    private final Optional<SimpleMarker> low;
    private final Optional<SimpleMarker> high;

    @JsonCreator
    public SimpleRange(@JsonProperty(value="low") Optional<SimpleMarker> low, @JsonProperty(value="high") Optional<SimpleMarker> high) {
        this.low = (Optional)Preconditions.checkNotNull(low, (Object)"low is null");
        this.high = (Optional)Preconditions.checkNotNull(high, (Object)"high is null");
    }

    @JsonProperty
    public Optional<SimpleMarker> getLow() {
        return this.low;
    }

    @JsonProperty
    public Optional<SimpleMarker> getHigh() {
        return this.high;
    }

    public static SimpleRange fromRange(Range range) {
        Preconditions.checkNotNull((Object)range, (Object)"range is null");
        return new SimpleRange(Optional.ofNullable(SimpleMarker.fromMarker(range.getLow())), Optional.ofNullable(SimpleMarker.fromMarker(range.getHigh())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRange that = (SimpleRange)o;
        return Objects.equal(this.low, that.low) && Objects.equal(this.high, that.high);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.low, this.high});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.low).addValue(this.high).toString();
    }
}

