/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SimpleRange;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.Range;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleDomain {
    private final boolean nullAllowed;
    private final Optional<List<SimpleRange>> ranges;

    @JsonCreator
    public SimpleDomain(@JsonProperty(value="nullAllowed") boolean nullAllowed, @JsonProperty(value="ranges") Optional<List<SimpleRange>> ranges) {
        this.nullAllowed = nullAllowed;
        Preconditions.checkNotNull(ranges, (Object)"ranges is null");
        ImmutableList rangesCopy = null;
        if (ranges.isPresent()) {
            rangesCopy = ImmutableList.copyOf((Collection)ranges.get());
        }
        this.ranges = Optional.ofNullable(rangesCopy);
    }

    @JsonProperty
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    @JsonProperty
    public Optional<List<SimpleRange>> getRanges() {
        return this.ranges;
    }

    private static List<SimpleRange> getSimpleRangeList(Domain domain) {
        Preconditions.checkNotNull((Object)domain, (Object)"domain is null");
        if (domain.isAll()) {
            return null;
        }
        if (domain.isNone()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder rangeBuilder = ImmutableList.builder();
        for (Range range : domain.getRanges()) {
            rangeBuilder.add((Object)SimpleRange.fromRange(range));
        }
        return rangeBuilder.build();
    }

    public static SimpleDomain fromDomain(Domain domain) {
        if (domain == null) {
            return null;
        }
        return new SimpleDomain(domain.isNullAllowed(), Optional.of(SimpleDomain.getSimpleRangeList(domain)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDomain that = (SimpleDomain)o;
        return Objects.equal((Object)this.nullAllowed, (Object)that.nullAllowed) && Objects.equal(this.ranges, that.ranges);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nullAllowed, this.ranges});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.nullAllowed).addValue(this.ranges).toString();
    }
}

