/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SetSession;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public void execute(SetSession statement, Session session, Metadata metadata, QueryStateMachine stateMachine) {
        if (statement.getName().getParts().size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", statement.getName());
        }
        stateMachine.addSetSessionProperties(statement.getName().toString(), statement.getValue());
    }
}

