/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemTableHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SystemTablesMetadata
extends ReadOnlyConnectorMetadata {
    private final ConcurrentMap<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();

    public void addTable(ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata) == null ? 1 : 0) != 0, (String)"Table %s is already registered", (Object[])new Object[]{tableMetadata.getTable()});
    }

    private SystemTableHandle checkTableHandle(ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = Types.checkType(tableHandle, SystemTableHandle.class, "tableHandle");
        Preconditions.checkArgument((boolean)this.tables.containsKey(systemTableHandle.getSchemaTableName()));
        return systemTableHandle;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        ImmutableSet schemaNames = ImmutableSet.copyOf((Iterable)Iterables.transform(this.tables.keySet(), SchemaTableName::getSchemaName));
        return ImmutableList.copyOf((Collection)schemaNames);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new SystemTableHandle(tableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        return (ConnectorTableMetadata)this.tables.get(systemTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return ImmutableList.copyOf(this.tables.keySet());
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.tables.keySet(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)schemaNameOrNull), SchemaTableName::getSchemaName)));
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        String columnName;
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = (ConnectorTableMetadata)this.tables.get(systemTableHandle.getSchemaTableName());
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = Types.checkType(columnHandle, SystemColumnHandle.class, "columnHandle").getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object[])new Object[]{columnName, tableMetadata.getTable()});
        return columnMetadata;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        SystemTableHandle systemTableHandle = this.checkTableHandle(tableHandle);
        return SystemColumnHandle.toSystemColumnHandles((ConnectorTableMetadata)this.tables.get(systemTableHandle.getSchemaTableName()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : this.tables.entrySet()) {
            if (!prefix.matches((SchemaTableName)entry.getKey())) continue;
            builder.put(entry.getKey(), (Object)((ConnectorTableMetadata)entry.getValue()).getColumns());
        }
        return builder.build();
    }
}

