/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaPageSourceProvider;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplitManager;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSinkProvider;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.RecordPageSinkProvider;
import com.facebook.presto.split.RecordPageSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class ConnectorManager {
    public static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    private final MetadataManager metadataManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IndexManager indexManager;
    private final PageSinkManager pageSinkManager;
    private final HandleResolver handleResolver;
    private final NodeManager nodeManager;
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    private final ConcurrentMap<String, Connector> connectors = new ConcurrentHashMap<String, Connector>();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, SplitManager splitManager, PageSourceManager pageSourceManager, IndexManager indexManager, PageSinkManager pageSinkManager, HandleResolver handleResolver, Map<String, ConnectorFactory> connectorFactories, NodeManager nodeManager) {
        this.metadataManager = metadataManager;
        this.splitManager = splitManager;
        this.pageSourceManager = pageSourceManager;
        this.indexManager = indexManager;
        this.pageSinkManager = pageSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.connectorFactories.putAll(connectorFactories);
    }

    public void addConnectorFactory(ConnectorFactory connectorFactory) {
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object[])new Object[]{connectorFactory.getName()});
    }

    public synchronized void createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)connectorName, (Object)"connectorName is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object[])new Object[]{connectorName});
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(connectorFactory.getClass().getClassLoader());){
            this.createConnection(catalogName, connectorFactory, properties);
        }
    }

    public synchronized void createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        Preconditions.checkNotNull((Object)connectorFactory, (Object)"connectorFactory is null");
        String connectorId = catalogName;
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        Connector connector = connectorFactory.create(connectorId, properties);
        this.connectors.put(connectorId, connector);
        this.addConnector(catalogName, connectorId, connector);
    }

    private void addConnector(String catalogName, String connectorId, Connector connector) {
        ConnectorMetadata connectorMetadata = connector.getMetadata();
        Preconditions.checkState((connectorMetadata != null ? 1 : 0) != 0, (String)"Connector %s can not provide metadata", (Object[])new Object[]{connectorId});
        ConnectorSplitManager connectorSplitManager = connector.getSplitManager();
        Preconditions.checkState((connectorSplitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object[])new Object[]{connectorId});
        ConnectorPageSourceProvider connectorPageSourceProvider = null;
        try {
            connectorPageSourceProvider = connector.getPageSourceProvider();
            Preconditions.checkNotNull((Object)connectorPageSourceProvider, (String)"Connector %s returned a null page source provider", (Object[])new Object[]{connectorId});
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        if (connectorPageSourceProvider == null) {
            ConnectorRecordSetProvider connectorRecordSetProvider = null;
            try {
                connectorRecordSetProvider = connector.getRecordSetProvider();
                Preconditions.checkNotNull((Object)connectorRecordSetProvider, (String)"Connector %s returned a null record set provider", (Object[])new Object[]{connectorId});
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
            Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s has neither a PageSource or RecordSet provider", (Object[])new Object[]{connectorId});
            connectorPageSourceProvider = new RecordPageSourceProvider(connectorRecordSetProvider);
        }
        ConnectorHandleResolver connectorHandleResolver = connector.getHandleResolver();
        Preconditions.checkNotNull((Object)connectorHandleResolver, (String)"Connector %s does not have a handle resolver", (Object[])new Object[]{connectorId});
        ConnectorPageSinkProvider connectorPageSinkProvider = null;
        try {
            connectorPageSinkProvider = connector.getPageSinkProvider();
            Preconditions.checkNotNull((Object)connectorPageSinkProvider, (String)"Connector %s returned a null page sink provider", (Object[])new Object[]{connectorId});
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        if (connectorPageSinkProvider == null) {
            ConnectorRecordSinkProvider connectorRecordSinkProvider = null;
            try {
                connectorRecordSinkProvider = connector.getRecordSinkProvider();
                Preconditions.checkNotNull((Object)connectorRecordSinkProvider, (String)"Connector %s returned a null record sink provider", (Object[])new Object[]{connectorId});
                connectorPageSinkProvider = new RecordPageSinkProvider(connectorRecordSinkProvider);
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
        }
        ConnectorIndexResolver indexResolver = null;
        try {
            indexResolver = connector.getIndexResolver();
            Preconditions.checkNotNull((Object)indexResolver, (String)"Connector %s returned a null index resolver", (Object[])new Object[]{connectorId});
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        this.metadataManager.addConnectorMetadata(connectorId, catalogName, connectorMetadata);
        this.metadataManager.addInformationSchemaMetadata(ConnectorManager.makeInformationSchemaConnectorId(connectorId), catalogName, new InformationSchemaMetadata(catalogName));
        this.splitManager.addConnectorSplitManager(ConnectorManager.makeInformationSchemaConnectorId(connectorId), new InformationSchemaSplitManager(this.nodeManager));
        this.pageSourceManager.addConnectorPageSourceProvider(ConnectorManager.makeInformationSchemaConnectorId(connectorId), new InformationSchemaPageSourceProvider(this.metadataManager, this.splitManager));
        this.splitManager.addConnectorSplitManager(connectorId, connectorSplitManager);
        this.handleResolver.addHandleResolver(connectorId, connectorHandleResolver);
        this.pageSourceManager.addConnectorPageSourceProvider(connectorId, connectorPageSourceProvider);
        if (connectorPageSinkProvider != null) {
            this.pageSinkManager.addConnectorPageSinkProvider(connectorId, connectorPageSinkProvider);
        }
        if (indexResolver != null) {
            this.indexManager.addIndexResolver(connectorId, indexResolver);
        }
    }

    private static String makeInformationSchemaConnectorId(String connectorId) {
        return INFORMATION_SCHEMA_CONNECTOR_PREFIX + connectorId;
    }
}

