/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class OrByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression left;
    private final ByteCodeExpression right;

    OrByteCodeExpression(ByteCodeExpression left, ByteCodeExpression right) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.left = (ByteCodeExpression)Preconditions.checkNotNull((Object)left, (Object)"left is null");
        Preconditions.checkArgument((left.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected left to be type boolean but is %s", (Object[])new Object[]{left.getType()});
        this.right = (ByteCodeExpression)Preconditions.checkNotNull((Object)right, (Object)"right is null");
        Preconditions.checkArgument((right.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected right to be type boolean but is %s", (Object[])new Object[]{right.getType()});
    }

    @Override
    public ByteCodeNode getByteCode() {
        LabelNode trueLabel = new LabelNode("true");
        LabelNode endLabel = new LabelNode("end");
        return new Block(null).append(this.left).ifTrueGoto(trueLabel).append(this.right).ifTrueGoto(trueLabel).push(false).gotoLabel(endLabel).visitLabel(trueLabel).push(true).visitLabel(endLabel);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    protected String formatOneLine() {
        return "(" + this.left + " || " + this.right + ")";
    }
}

