/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class NotByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression value;

    NotByteCodeExpression(ByteCodeExpression value) {
        super(ParameterizedType.type(Boolean.TYPE));
        this.value = value;
        Preconditions.checkArgument((value.getType().getPrimitiveType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected value to be type boolean but is %s", (Object[])new Object[]{value.getType()});
    }

    @Override
    public ByteCodeNode getByteCode() {
        LabelNode trueLabel = new LabelNode("true");
        LabelNode endLabel = new LabelNode("end");
        return new Block(null).append(this.value).ifTrueGoto(trueLabel).push(true).gotoLabel(endLabel).visitLabel(trueLabel).push(false).visitLabel(endLabel);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    protected String formatOneLine() {
        return "(!" + this.value + ")";
    }
}

