/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeNodeFactory;
import com.facebook.presto.byteCode.ByteCodeNodes;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ExpectedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class WhileLoop
implements FlowControl {
    private final CompilerContext context;
    private final String comment;
    private final ByteCodeNode condition;
    private final ByteCodeNode body;
    private final LabelNode beginLabel;
    private final LabelNode endLabel;

    public static WhileLoopBuilder whileLoopBuilder(CompilerContext context) {
        return new WhileLoopBuilder(context);
    }

    private WhileLoop(CompilerContext context, String comment, ByteCodeNode condition, ByteCodeNode body, LabelNode beginLabel, LabelNode endLabel) {
        this.context = context;
        this.comment = comment;
        this.condition = condition;
        this.body = body;
        this.beginLabel = beginLabel;
        this.endLabel = endLabel;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeNode getCondition() {
        return this.condition;
    }

    public ByteCodeNode getBody() {
        return this.body;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        Block block = new Block(this.context).visitLabel(this.beginLabel).append(this.condition).ifZeroGoto(this.endLabel).append(this.body).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.condition, (Object)this.body);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitWhile(parent, this);
    }

    public static class WhileLoopBuilder {
        private final CompilerContext context;
        private final LabelNode beginLabel = new LabelNode("begin");
        private final LabelNode endLabel = new LabelNode("end");
        private String comment;
        private ByteCodeNode condition;
        private ByteCodeNode body;

        public WhileLoopBuilder(CompilerContext context) {
            this.context = context;
            context.pushIterationScope(this.beginLabel, this.endLabel);
        }

        public WhileLoopBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public WhileLoopBuilder condition(ByteCodeNode condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, "condition");
            return this;
        }

        public WhileLoopBuilder condition(ByteCodeNodeFactory condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, ExpectedType.BOOLEAN, "condition");
            return this;
        }

        public WhileLoopBuilder body(ByteCodeNode body) {
            this.body = ByteCodeNodes.buildBlock(this.context, body, "body");
            return this;
        }

        public WhileLoopBuilder body(ByteCodeNodeFactory body) {
            this.body = ByteCodeNodes.buildBlock(this.context, body, ExpectedType.VOID, "body");
            return this;
        }

        public WhileLoop build() {
            WhileLoop whileLoop = new WhileLoop(this.context, this.comment, this.condition, this.body, this.beginLabel, this.endLabel);
            this.context.popIterationScope();
            return whileLoop;
        }
    }
}

