/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Ints;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CaseStatement
implements Comparable<CaseStatement> {
    private final int key;
    private final LabelNode label;

    public static CaseStatement caseStatement(int key, LabelNode label) {
        return new CaseStatement(label, key);
    }

    CaseStatement(LabelNode label, int key) {
        this.label = label;
        this.key = key;
    }

    public int getKey() {
        return this.key;
    }

    public LabelNode getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(CaseStatement o) {
        return Ints.compare((int)this.key, (int)o.key);
    }

    public int hashCode() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CaseStatement other = (CaseStatement)obj;
        return Objects.equal((Object)this.key, (Object)other.key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("label", (Object)this.label).toString();
    }
}

