/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.client.ClientSession;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nullable;

public final class Session {
    private final String user;
    @Nullable
    private final String source;
    private final String catalog;
    private final String schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    @Nullable
    private final String remoteUserAddress;
    @Nullable
    private final String userAgent;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;

    @JsonCreator
    public Session(@JsonProperty(value="user") String user, @JsonProperty(value="source") @Nullable String source, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") @Nullable String remoteUserAddress, @JsonProperty(value="userAgent") @Nullable String userAgent, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<String, Map<String, String>> catalogProperties) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.source = source;
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = remoteUserAddress;
        this.userAgent = userAgent;
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        catalogProperties.entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), (Object)ImmutableMap.copyOf((Map)((Map)entry.getValue())))).forEach(arg_0 -> ((ImmutableMap.Builder)catalogPropertiesBuilder).put(arg_0));
        this.catalogProperties = catalogPropertiesBuilder.build();
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @Nullable
    @JsonProperty
    public String getSource() {
        return this.source;
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @Nullable
    @JsonProperty
    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @Nullable
    @JsonProperty
    public String getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Session withSystemProperty(String key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        LinkedHashMap<String, String> systemProperties = new LinkedHashMap<String, String>(this.systemProperties);
        systemProperties.put(key, value);
        return new Session(this.user, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, systemProperties, this.catalogProperties);
    }

    public Session withCatalogProperty(String catalog, String key, String value) {
        Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        LinkedHashMap<String, Map<String, String>> catalogProperties = new LinkedHashMap<String, Map<String, String>>(this.catalogProperties);
        LinkedHashMap<String, String> properties = (LinkedHashMap<String, String>)catalogProperties.get(catalog);
        properties = properties == null ? new LinkedHashMap<String, String>() : new LinkedHashMap(properties);
        properties.put(key, value);
        catalogProperties.put(catalog, properties);
        return new Session(this.user, this.source, catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, catalogProperties);
    }

    public ConnectorSession toConnectorSession() {
        return new ConnectorSession(this.user, this.timeZoneKey, this.locale, this.startTime, null);
    }

    public ConnectorSession toConnectorSession(String catalog) {
        return new ConnectorSession(this.user, this.timeZoneKey, this.locale, this.startTime, this.catalogProperties.get(Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null")));
    }

    public ClientSession toClientSession(URI server, boolean debug) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.putAll(this.systemProperties);
        for (Map.Entry<String, Map<String, String>> catalogProperties : this.catalogProperties.entrySet()) {
            String catalog = catalogProperties.getKey();
            for (Map.Entry<String, String> entry : catalogProperties.getValue().entrySet()) {
                properties.put((Object)(catalog + "." + entry.getKey()), (Object)entry.getValue());
            }
        }
        return new ClientSession((URI)Preconditions.checkNotNull((Object)server, (Object)"server is null"), this.user, this.source, this.catalog, this.schema, this.timeZoneKey.getId(), this.locale, (Map)properties.build(), debug);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.user).add("source", (Object)this.source).add("catalog", (Object)this.catalog).add("schema", (Object)this.schema).add("timeZoneKey", (Object)this.timeZoneKey).add("locale", (Object)this.locale).add("remoteUserAddress", (Object)this.remoteUserAddress).add("userAgent", (Object)this.userAgent).add("startTime", this.startTime).toString();
    }

    public static SessionBuilder builder() {
        return new SessionBuilder();
    }

    public static class SessionBuilder {
        private String user;
        private String source;
        private String catalog;
        private String schema;
        private TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)TimeZone.getDefault().getID());
        private Locale locale = Locale.getDefault();
        private String remoteUserAddress;
        private String userAgent;
        private long startTime = System.currentTimeMillis();
        private Map<String, String> systemProperties = ImmutableMap.of();
        private final Map<String, Map<String, String>> catalogProperties = new HashMap<String, Map<String, String>>();

        private SessionBuilder() {
        }

        public SessionBuilder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public SessionBuilder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public SessionBuilder setRemoteUserAddress(String remoteUserAddress) {
            this.remoteUserAddress = remoteUserAddress;
            return this;
        }

        public SessionBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public SessionBuilder setSource(String source) {
            this.source = source;
            return this;
        }

        public SessionBuilder setStartTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SessionBuilder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = timeZoneKey;
            return this;
        }

        public SessionBuilder setUser(String user) {
            this.user = user;
            return this;
        }

        public SessionBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public SessionBuilder setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = ImmutableMap.copyOf(systemProperties);
            return this;
        }

        public SessionBuilder setCatalogProperties(String catalog, Map<String, String> properties) {
            Preconditions.checkNotNull((Object)catalog, (Object)"catalog is null");
            Preconditions.checkArgument((!catalog.isEmpty() ? 1 : 0) != 0, (Object)"catalog is empty");
            this.catalogProperties.put(catalog, (Map<String, String>)ImmutableMap.copyOf(properties));
            return this;
        }

        public Session build() {
            return new Session(this.user, this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties);
        }
    }
}

