/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public final class HashPagePartitionFunction
implements PagePartitionFunction {
    private final int partition;
    private final int partitionCount;
    private final List<Integer> partitioningChannels;
    private final List<Type> types;
    private final HashGenerator hashGenerator;
    private final Optional<Integer> hashChannel;

    @JsonCreator
    public HashPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="partitioningChannels") List<Integer> partitioningChannels, @JsonProperty(value="hashChannel") Optional<Integer> hashChannel, @JsonProperty(value="types") List<Type> types) {
        Preconditions.checkNotNull(partitioningChannels, (Object)"partitioningChannels is null");
        Preconditions.checkArgument((!partitioningChannels.isEmpty() ? 1 : 0) != 0, (Object)"partitioningChannels is empty");
        this.hashChannel = (Optional)Preconditions.checkNotNull(hashChannel, (Object)"hashChannel is null");
        Preconditions.checkArgument((!hashChannel.isPresent() || hashChannel.get() < types.size() ? 1 : 0) != 0, (Object)"invalid hashChannel");
        this.partition = partition;
        this.partitionCount = partitionCount;
        this.partitioningChannels = ImmutableList.copyOf(partitioningChannels);
        this.hashGenerator = HashPagePartitionFunction.createHashGenerator(hashChannel, partitioningChannels, types);
        this.types = ImmutableList.copyOf(types);
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @JsonProperty
    public List<Integer> getPartitioningChannels() {
        return this.partitioningChannels;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public Optional<Integer> getHashChannel() {
        return this.hashChannel;
    }

    @Override
    public List<Page> partition(List<Page> pages) {
        if (pages.isEmpty()) {
            return pages;
        }
        PageBuilder pageBuilder = new PageBuilder(this.types);
        ImmutableList.Builder partitionedPages = ImmutableList.builder();
        for (Page page : pages) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int partitionHashBucket = this.getPartitionHashBucket(position, page);
                if (partitionHashBucket != this.partition) continue;
                pageBuilder.declarePosition();
                for (int channel = 0; channel < this.types.size(); ++channel) {
                    Type type = this.types.get(channel);
                    type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
                }
                if (!pageBuilder.isFull()) continue;
                partitionedPages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
        }
        if (!pageBuilder.isEmpty()) {
            partitionedPages.add((Object)pageBuilder.build());
        }
        return partitionedPages.build();
    }

    private int getPartitionHashBucket(int position, Page page) {
        int rawHash = this.hashGenerator.hashPosition(position, page);
        int bucket = (rawHash = (int)((long)rawHash & Integer.MAX_VALUE)) % this.partitionCount;
        Preconditions.checkState((bucket >= 0 && bucket < this.partitionCount ? 1 : 0) != 0);
        return bucket;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partition, this.partitionCount, this.partitioningChannels, this.hashGenerator});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashPagePartitionFunction other = (HashPagePartitionFunction)obj;
        return Objects.equal((Object)this.partition, (Object)other.partition) && Objects.equal((Object)this.partitionCount, (Object)other.partitionCount) && Objects.equal(this.partitioningChannels, other.partitioningChannels) && Objects.equal(this.hashChannel, other.hashChannel);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).add("partitioningChannels", this.partitioningChannels).add("hashChannel", this.hashChannel).toString();
    }

    private static HashGenerator createHashGenerator(Optional<Integer> hashChannel, List<Integer> partitioningChannels, List<Type> types) {
        if (hashChannel.isPresent()) {
            return new PrecomputedHashGenerator(hashChannel.get());
        }
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        int[] hashChannels = new int[partitioningChannels.size()];
        for (int i = 0; i < partitioningChannels.size(); ++i) {
            int channel = partitioningChannels.get(i);
            hashTypes.add((Object)types.get(channel));
            hashChannels[i] = channel;
        }
        return new InterpretedHashGenerator((List<Type>)hashTypes.build(), hashChannels);
    }
}

