/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import com.google.common.io.LineReader;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class DelimitedRecordSet
implements RecordSet {
    private final CharSource charSource;
    private final Splitter columnSplitter;
    private final List<ColumnMetadata> columns;
    private final List<Type> columnTypes;

    public DelimitedRecordSet(CharSource charSource, Splitter columnSplitter, ColumnMetadata ... columns) {
        this(charSource, columnSplitter, (Iterable<ColumnMetadata>)ImmutableList.copyOf((Object[])columns));
    }

    public DelimitedRecordSet(CharSource charSource, Splitter columnSplitter, Iterable<ColumnMetadata> columns) {
        this.charSource = (CharSource)Preconditions.checkNotNull((Object)charSource, (Object)"charSource is null");
        this.columnSplitter = (Splitter)Preconditions.checkNotNull((Object)columnSplitter, (Object)"columnSplitter is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform(columns, ColumnMetadata::getType));
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new DelimitedRecordCursor(this.charSource, this.columnSplitter, this.columns);
    }

    private static class DelimitedRecordCursor
    implements RecordCursor {
        private final Reader reader;
        private final LineReader lineReader;
        private final Splitter columnSplitter;
        private final List<ColumnMetadata> columns;
        private List<String> row;

        private DelimitedRecordCursor(CharSource charSource, Splitter columnSplitter, List<ColumnMetadata> columns) {
            try {
                this.reader = charSource.openStream();
                this.lineReader = new LineReader((Readable)this.reader);
                this.columnSplitter = columnSplitter;
                this.columns = columns;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return this.columns.get(field).getType();
        }

        public boolean advanceNextPosition() {
            try {
                String line = this.lineReader.readLine();
                if (line == null) {
                    this.row = null;
                    return false;
                }
                this.row = ImmutableList.copyOf((Iterable)this.columnSplitter.split((CharSequence)line));
                return true;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public boolean getBoolean(int field) {
            return Boolean.parseBoolean(this.getField(field));
        }

        public long getLong(int field) {
            return Long.parseLong(this.getField(field));
        }

        public double getDouble(int field) {
            return Double.parseDouble(this.getField(field));
        }

        public Slice getSlice(int field) {
            return Slices.utf8Slice((String)this.getField(field));
        }

        public boolean isNull(int field) {
            return this.getField(field).isEmpty();
        }

        private String getField(int field) {
            ColumnMetadata columnMetadata = this.columns.get(field);
            return this.row.get(columnMetadata.getOrdinalPosition());
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

