/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.SqlIntervalYearMonth;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class IntervalYearMonthOperators {
    private IntervalYearMonthOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval year to month")
    public static long add(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval year to month")
    public static long subtract(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByBigint(@SqlType(value="interval year to month") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long multiplyByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval year to month") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval year to month")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval year to month") long right) {
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval year to month")
    public static long divideByDouble(@SqlType(value="interval year to month") long left, @SqlType(value="double") double right) {
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval year to month")
    public static long negate(@SqlType(value="interval year to month") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval year to month") long left, @SqlType(value="interval year to month") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval year to month") long value, @SqlType(value="interval year to month") long min, @SqlType(value="interval year to month") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(@SqlType(value="interval year to month") long value) {
        return Slices.utf8Slice((String)SqlIntervalYearMonth.formatMonths((long)value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval year to month") long value) {
        return (int)(value ^ value >>> 32);
    }
}

