/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.planner.DomainUtils;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final SummarizedPartition summarizedPartition;
    private final boolean partitionsDroppedBySerialization;
    private final Expression originalConstraint;

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, @Nullable Expression originalConstraint, Optional<GeneratedPartitions> generatedPartitions) {
        this(id, table, outputSymbols, assignments, originalConstraint, new SummarizedPartition(generatedPartitions), false);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, @Nullable Expression originalConstraint, SummarizedPartition summarizedPartition) {
        this(id, table, outputSymbols, assignments, originalConstraint, summarizedPartition, false);
    }

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="originalConstraint") @Nullable Expression originalConstraint) {
        this(id, table, outputSymbols, assignments, originalConstraint, new SummarizedPartition(Optional.empty()), true);
    }

    private TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments, @Nullable Expression originalConstraint, SummarizedPartition summarizedPartition, boolean partitionsDroppedBySerialization) {
        super(id);
        Preconditions.checkNotNull((Object)table, (Object)"table is null");
        Preconditions.checkNotNull(outputSymbols, (Object)"outputSymbols is null");
        Preconditions.checkNotNull(assignments, (Object)"assignments is null");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputSymbols), (Object)"assignments does not cover all of outputSymbols");
        Preconditions.checkNotNull((Object)summarizedPartition, (Object)"summarizedPartition is null");
        this.table = table;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.assignments = ImmutableMap.copyOf(assignments);
        this.originalConstraint = originalConstraint;
        this.summarizedPartition = summarizedPartition;
        this.partitionsDroppedBySerialization = partitionsDroppedBySerialization;
        Preconditions.checkArgument((summarizedPartition.getPartitionDomainSummary().isNone() || ImmutableSet.copyOf(assignments.values()).containsAll(summarizedPartition.getPartitionDomainSummary().getDomains().keySet()) ? 1 : 0) != 0, (Object)"Assignments do not include all of the ColumnHandles specified by the Partitions");
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @Nullable
    @JsonProperty(value="originalConstraint")
    public Expression getOriginalConstraint() {
        return this.originalConstraint;
    }

    public Optional<GeneratedPartitions> getGeneratedPartitions() {
        Preconditions.checkState((!this.partitionsDroppedBySerialization ? 1 : 0) != 0, (Object)"Can't access partitions after passing through serialization");
        return this.summarizedPartition.getGeneratedPartitions();
    }

    public TupleDomain<ColumnHandle> getPartitionsDomainSummary() {
        return this.summarizedPartition.getPartitionDomainSummary();
    }

    public SummarizedPartition getSummarizedPartition() {
        return this.summarizedPartition;
    }

    @JsonProperty(value="partitionDomainSummary")
    public String getPrintablePartitionDomainSummary() {
        StringBuilder builder = new StringBuilder().append("TupleDomain:");
        if (this.summarizedPartition.getPartitionDomainSummary().isAll()) {
            builder.append("ALL");
        } else if (this.summarizedPartition.getPartitionDomainSummary().isNone()) {
            builder.append("NONE");
        } else {
            builder.append(Maps.transformValues(DomainUtils.columnHandleToSymbol(this.summarizedPartition.getPartitionDomainSummary().getDomains(), this.assignments), DomainUtils::simplifyDomain));
        }
        return builder.toString();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public static final class GeneratedPartitions {
        private final TupleDomain<ColumnHandle> tupleDomainInput;
        private final List<Partition> partitions;

        public GeneratedPartitions(TupleDomain<ColumnHandle> tupleDomainInput, List<Partition> partitions) {
            this.tupleDomainInput = (TupleDomain)Preconditions.checkNotNull(tupleDomainInput, (Object)"tupleDomainInput is null");
            this.partitions = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitions, (Object)"partitions is null")));
        }

        public TupleDomain<ColumnHandle> getTupleDomainInput() {
            return this.tupleDomainInput;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.tupleDomainInput, this.partitions});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GeneratedPartitions other = (GeneratedPartitions)obj;
            return Objects.equal(this.tupleDomainInput, other.tupleDomainInput) && Objects.equal(this.partitions, other.partitions);
        }
    }

    public static final class SummarizedPartition {
        private final Optional<GeneratedPartitions> generatedPartitions;
        private final TupleDomain<ColumnHandle> partitionDomainSummary;

        public SummarizedPartition(Optional<GeneratedPartitions> generatedPartitions) {
            this.generatedPartitions = (Optional)Preconditions.checkNotNull(generatedPartitions, (Object)"generatedPartitions is null");
            this.partitionDomainSummary = SummarizedPartition.computePartitionsDomainSummary(generatedPartitions);
        }

        private static TupleDomain<ColumnHandle> computePartitionsDomainSummary(Optional<GeneratedPartitions> generatedPartitions) {
            if (!generatedPartitions.isPresent()) {
                return TupleDomain.all();
            }
            if (generatedPartitions.get().getPartitions().isEmpty()) {
                return TupleDomain.none();
            }
            ImmutableList domains = FluentIterable.from(generatedPartitions.get().getPartitions()).transform(Partition::getTupleDomain).toList();
            return TupleDomain.columnWiseUnion((List)domains);
        }

        public TupleDomain<ColumnHandle> getPartitionDomainSummary() {
            return this.partitionDomainSummary;
        }

        public Optional<GeneratedPartitions> getGeneratedPartitions() {
            return this.generatedPartitions;
        }
    }
}

