/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Map<Symbol, Expression> assignments;
    private final List<Symbol> outputs;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Map<Symbol, Expression> assignments) {
        super(id);
        this.source = source;
        this.assignments = ImmutableMap.copyOf(assignments);
        this.outputs = ImmutableList.copyOf(assignments.keySet());
    }

    public List<Expression> getExpressions() {
        return ImmutableList.copyOf(this.assignments.values());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public Map<Symbol, Expression> getAssignments() {
        return this.assignments;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitProject(this, context);
    }
}

