/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExchangeNode
extends PlanNode {
    private final Type type;
    private final List<Symbol> outputs;
    private final List<PlanNode> sources;
    private final List<Symbol> partitionKeys;
    private final Optional<Symbol> hashSymbol;
    private final List<List<Symbol>> inputs;

    @JsonCreator
    public ExchangeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="partitionKeys") List<Symbol> partitionKeys, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="inputs") List<List<Symbol>> inputs) {
        super(id);
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        Preconditions.checkNotNull(sources, (Object)"sources is null");
        Preconditions.checkNotNull(partitionKeys, (Object)"partitionKeys is null");
        Preconditions.checkNotNull(hashSymbol, (Object)"hashSymbol is null");
        Preconditions.checkNotNull(outputs, (Object)"outputs is null");
        Preconditions.checkNotNull(inputs, (Object)"inputs is null");
        this.type = type;
        this.sources = sources;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.hashSymbol = hashSymbol;
        this.outputs = ImmutableList.copyOf(outputs);
        this.inputs = ImmutableList.copyOf(inputs);
    }

    public static ExchangeNode partitionedExchange(PlanNodeId id, PlanNode child, List<Symbol> partitionKeys, Optional<Symbol> hashSymbol) {
        return new ExchangeNode(id, Type.REPARTITION, partitionKeys, hashSymbol, (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    public static ExchangeNode gatheringExchange(PlanNodeId id, PlanNode child) {
        return new ExchangeNode(id, Type.GATHER, (List<Symbol>)ImmutableList.of(), Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)child), child.getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(child.getOutputSymbols()));
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @JsonProperty
    public List<Symbol> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public List<List<Symbol>> getInputs() {
        return this.inputs;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitExchange(this, context);
    }

    public static enum Type {
        GATHER,
        REPARTITION,
        REPLICATE;

    }
}

