/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DistinctLimitNode
extends PlanNode {
    private final PlanNode source;
    private final long limit;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public DistinctLimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="limit") long limit, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be greater than or equal to zero");
        this.limit = limit;
        this.hashSymbol = (Optional)Preconditions.checkNotNull(hashSymbol, (Object)"hashSymbol is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="limit")
    public long getLimit() {
        return this.limit;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    public List<Symbol> getDistinctSymbols() {
        if (this.hashSymbol.isPresent()) {
            return ImmutableList.copyOf((Iterable)Iterables.filter(this.getOutputSymbols(), (Predicate)Predicates.not(this.hashSymbol.get()::equals)));
        }
        return this.getOutputSymbols();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitDistinctLimit(this, context);
    }
}

