/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.util.ImmutableCollectors;
import java.util.List;
import java.util.Map;

public class NormalizeJoinOrder
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new PlanRewriter<Void>(){

            @Override
            public PlanNode visitJoin(JoinNode node, PlanRewriter.RewriteContext<Void> context) {
                if (node.getType() != JoinNode.Type.RIGHT) {
                    return context.defaultRewrite(node);
                }
                return new JoinNode(node.getId(), JoinNode.Type.LEFT, context.rewrite(node.getRight()), context.rewrite(node.getLeft()), (List)node.getCriteria().stream().map(criteria -> new JoinNode.EquiJoinClause(criteria.getRight(), criteria.getLeft())).collect(ImmutableCollectors.toImmutableList()), node.getRightHashSymbol(), node.getLeftHashSymbol());
            }
        }, plan);
    }
}

