/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MetadataQueryOptimizer
extends PlanOptimizer {
    private static final Set<String> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)"max", (Object)"min", (Object)"approx_distinct");
    private final Metadata metadata;
    private final SplitManager splitManager;

    public MetadataQueryOptimizer(Metadata metadata, SplitManager splitManager) {
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
        this.metadata = metadata;
        this.splitManager = splitManager;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Optimizer(this.metadata, this.splitManager, idAllocator), plan, null);
    }

    private static class Replacer
    extends PlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, PlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }

    private static class Optimizer
    extends PlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final SplitManager splitManager;

        private Optimizer(Metadata metadata, SplitManager splitManager, PlanNodeIdAllocator idAllocator) {
            this.metadata = metadata;
            this.splitManager = splitManager;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, PlanRewriter.RewriteContext<Void> context) {
            for (FunctionCall call : node.getAggregations().values()) {
                if (ALLOWED_FUNCTIONS.contains(call.getName().toString()) || call.isDistinct()) continue;
                return null;
            }
            Optional<TableScanNode> result = this.findTableScan(node.getSource());
            if (!result.isPresent()) {
                return null;
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List<Symbol> inputs = tableScan.getOutputSymbols();
            for (Symbol symbol : inputs) {
                ColumnHandle column = tableScan.getAssignments().get(symbol);
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(tableScan.getTable(), column);
                if (!columnMetadata.isPartitionKey()) {
                    return null;
                }
                typesBuilder.put((Object)symbol, (Object)columnMetadata.getType());
                columnBuilder.put((Object)symbol, (Object)column);
            }
            ImmutableMap columns = columnBuilder.build();
            ImmutableMap types = typesBuilder.build();
            List<Partition> partitions = tableScan.getGeneratedPartitions().isPresent() ? tableScan.getGeneratedPartitions().get().getPartitions() : this.splitManager.getPartitions(result.get().getTable(), Optional.of(tableScan.getPartitionsDomainSummary())).getPartitions();
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (Partition partition : partitions) {
                Map entries = partition.getTupleDomain().extractNullableFixedValues();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (Symbol input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    Type type = (Type)types.get(input);
                    SerializableNativeValue value = (SerializableNativeValue)entries.get(column);
                    if (value == null) {
                        return null;
                    }
                    rowBuilder.add((Object)LiteralInterpreter.toExpression(value.getValue(), type));
                }
                rowsBuilder.add((Object)rowBuilder.build());
            }
            ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), inputs, (List<List<Expression>>)rowsBuilder.build());
            return PlanRewriter.rewriteWith(new Replacer(valuesNode), node);
        }

        private Optional<TableScanNode> findTableScan(PlanNode source) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all(project.getExpressions(), DeterminismEvaluator::isDeterministic)) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                return Optional.of((TableScanNode)source);
            }
            return Optional.empty();
        }
    }
}

