/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class AddExchanges
extends PlanOptimizer {
    private final Metadata metadata;
    private final boolean distributedIndexJoins;
    private final boolean distributedJoins;

    public AddExchanges(Metadata metadata, boolean distributedIndexJoins, boolean distributedJoins) {
        this.metadata = metadata;
        this.distributedIndexJoins = distributedIndexJoins;
        this.distributedJoins = distributedJoins;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        PlanWithProperties result = plan.accept(new Rewriter(symbolAllocator, idAllocator, session, this.distributedIndexJoins, this.distributedJoins), null);
        return result.getNode();
    }

    private static class PlacementProperties {
        private final Type type;

        public static PlacementProperties anywhere() {
            return new PlacementProperties(Type.ANY);
        }

        public static PlacementProperties source() {
            return new PlacementProperties(Type.SOURCE);
        }

        public static PlacementProperties coordinatorOnly() {
            return new PlacementProperties(Type.COORDINATOR_ONLY);
        }

        private PlacementProperties(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.type.toString();
        }

        public static enum Type {
            COORDINATOR_ONLY,
            SOURCE,
            ANY;

        }
    }

    private static class PartitioningProperties {
        private final Type type;
        private final Optional<Symbol> hashSymbol;
        private final Optional<List<Symbol>> keys;

        public static PartitioningProperties arbitrary() {
            return new PartitioningProperties(Type.PARTITIONED);
        }

        public static PartitioningProperties unpartitioned() {
            return new PartitioningProperties(Type.UNPARTITIONED);
        }

        public static PartitioningProperties partitioned(List<Symbol> symbols, Optional<Symbol> hashSymbol) {
            return new PartitioningProperties(Type.PARTITIONED, symbols, hashSymbol);
        }

        private PartitioningProperties(Type type) {
            this.type = type;
            this.keys = Optional.empty();
            this.hashSymbol = Optional.empty();
        }

        private PartitioningProperties(Type type, List<Symbol> keys, Optional<Symbol> hashSymbol) {
            this.type = type;
            this.keys = Optional.of(keys);
            this.hashSymbol = hashSymbol;
        }

        public Type getType() {
            return this.type;
        }

        public Optional<List<Symbol>> getKeys() {
            return this.keys;
        }

        public Optional<Symbol> getHashSymbol() {
            return this.hashSymbol;
        }

        public String toString() {
            if (this.type == Type.PARTITIONED) {
                return this.type.toString() + ": " + (this.keys.isPresent() ? this.keys.get() : "*");
            }
            return this.type.toString();
        }

        public static enum Type {
            UNPARTITIONED,
            PARTITIONED;

        }
    }

    private static class ActualProperties {
        private final PartitioningProperties partitioning;
        private final PlacementProperties placement;

        public ActualProperties(PartitioningProperties partitioning, PlacementProperties placement) {
            this.partitioning = partitioning;
            this.placement = placement;
        }

        public static ActualProperties of(PartitioningProperties partitioning, PlacementProperties placement) {
            return new ActualProperties(partitioning, placement);
        }

        public PartitioningProperties getPartitioning() {
            return this.partitioning;
        }

        public boolean isCoordinatorOnly() {
            return this.placement.getType() == PlacementProperties.Type.COORDINATOR_ONLY;
        }

        public boolean isPartitioned() {
            return this.partitioning.getType() == PartitioningProperties.Type.PARTITIONED;
        }

        public boolean isPartitionedOnKeys(List<Symbol> keys) {
            return this.isPartitioned() && this.partitioning.getKeys().isPresent() && this.partitioning.getKeys().get().equals(keys);
        }

        public boolean isUnpartitioned() {
            return this.partitioning.getType() == PartitioningProperties.Type.UNPARTITIONED;
        }

        public String toString() {
            return "partitioning: " + this.partitioning + ", placement: " + this.placement;
        }
    }

    private static class Requirements {
        private final Optional<PartitioningProperties> partitioning;
        private final Optional<PlacementProperties> placement;

        private Requirements(Optional<PartitioningProperties> partitioning, Optional<PlacementProperties> placement) {
            this.partitioning = partitioning;
            this.placement = placement;
        }

        public static Requirements of(PartitioningProperties partitioning) {
            return new Requirements(Optional.of(partitioning), Optional.empty());
        }

        public static Requirements of(PartitioningProperties partitioning, PlacementProperties placement) {
            return new Requirements(Optional.of(partitioning), Optional.of(placement));
        }

        public Optional<PartitioningProperties> getPartitioning() {
            return this.partitioning;
        }

        public String toString() {
            return "partitioning: " + (this.partitioning.isPresent() ? this.partitioning.get() : "*") + "," + "placement: " + (this.placement.isPresent() ? this.placement.get() : "*");
        }

        public boolean isCoordinatorOnly() {
            return this.placement.isPresent() && this.placement.get().getType() == PlacementProperties.Type.COORDINATOR_ONLY;
        }

        public boolean isUnpartitioned() {
            return this.partitioning.isPresent() && this.partitioning.get().getType() == PartitioningProperties.Type.UNPARTITIONED;
        }

        public boolean isPartitionedOnKeys() {
            return this.isPartitioned() && this.partitioning.get().getKeys().isPresent();
        }

        public boolean isPartitioned() {
            return this.partitioning.isPresent() && this.partitioning.get().getType() == PartitioningProperties.Type.PARTITIONED;
        }
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends PlanVisitor<Void, PlanWithProperties> {
        private final SymbolAllocator allocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final boolean distributedIndexJoins;
        private final boolean distributedJoins;

        public Rewriter(SymbolAllocator allocator, PlanNodeIdAllocator idAllocator, Session session, boolean distributedIndexJoins, boolean distributedJoins) {
            this.allocator = allocator;
            this.idAllocator = idAllocator;
            this.session = session;
            this.distributedIndexJoins = distributedIndexJoins;
            this.distributedJoins = distributedJoins;
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, Void context) {
            PlanWithProperties source = ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, context);
            return this.propagateChildProperties(node, source);
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, Void context) {
            return this.pushRequirementsToChild(node, Requirements.of(PartitioningProperties.unpartitioned()));
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, Void context) {
            boolean decomposable = node.getFunctions().values().stream().map(AddExchanges.this.metadata::getExactFunction).map(FunctionInfo::getAggregationFunction).allMatch(InternalAggregationFunction::isDecomposable);
            if (!decomposable) {
                return this.pushRequirementsToChild(node, Requirements.of(PartitioningProperties.unpartitioned()));
            }
            PlanWithProperties source = node.getSource().accept(this, context);
            if (source.getProperties().isUnpartitioned() || !node.getGroupBy().isEmpty() && source.getProperties().isPartitionedOnKeys(node.getGroupBy())) {
                return this.propagateChildProperties(node, source);
            }
            Map<Symbol, Symbol> masks = node.getMasks();
            HashMap<Symbol, FunctionCall> finalCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, FunctionCall> intermediateCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, Signature> intermediateFunctions = new HashMap<Symbol, Signature>();
            HashMap<Symbol, Symbol> intermediateMask = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Signature signature = node.getFunctions().get(entry.getKey());
                FunctionInfo function = AddExchanges.this.metadata.getExactFunction(signature);
                Symbol intermediateSymbol = this.allocator.newSymbol(function.getName().getSuffix(), AddExchanges.this.metadata.getType(function.getIntermediateType()));
                intermediateCalls.put(intermediateSymbol, entry.getValue());
                intermediateFunctions.put(intermediateSymbol, signature);
                if (masks.containsKey(entry.getKey())) {
                    intermediateMask.put(intermediateSymbol, masks.get(entry.getKey()));
                }
                finalCalls.put(entry.getKey(), new FunctionCall(function.getName(), (List)ImmutableList.of((Object)new QualifiedNameReference(intermediateSymbol.toQualifiedName()))));
            }
            return this.enforceWithPartial(source, this.computePartitioningRequirements(node.getGroupBy(), node.getHashSymbol()), child -> new AggregationNode(this.idAllocator.getNextId(), (PlanNode)child, node.getGroupBy(), (Map<Symbol, FunctionCall>)intermediateCalls, (Map<Symbol, Signature>)intermediateFunctions, (Map<Symbol, Symbol>)intermediateMask, AggregationNode.Step.PARTIAL, node.getSampleWeight(), node.getConfidence(), node.getHashSymbol()), child -> new AggregationNode(node.getId(), (PlanNode)child, node.getGroupBy(), (Map<Symbol, FunctionCall>)finalCalls, node.getFunctions(), (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.FINAL, Optional.empty(), node.getConfidence(), node.getHashSymbol()));
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, Void context) {
            PlanWithProperties child = node.getSource().accept(this, context);
            if (child.getProperties().isPartitioned() || SystemSessionProperties.isBigQueryEnabled(this.session, false)) {
                child = this.enforce(child, Requirements.of(PartitioningProperties.partitioned(node.getDistinctSymbols(), node.getHashSymbol())));
            }
            return this.propagateChildProperties(node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, Void context) {
            return this.pushRequirementsToChild(node, this.computePartitioningRequirements(node.getPartitionBy(), node.getHashSymbol()));
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, Void context) {
            return this.pushRequirementsToChild(node, this.computePartitioningRequirements(node.getPartitionBy(), node.getHashSymbol()));
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return this.pushRequirementsToChildWithPartial(node, this.computePartitioningRequirements(node.getPartitionBy(), node.getHashSymbol()), child -> new TopNRowNumberNode(this.idAllocator.getNextId(), (PlanNode)child, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), true, node.getHashSymbol()), child -> new TopNRowNumberNode(node.getId(), (PlanNode)child, node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), false, node.getHashSymbol()));
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, Void context) {
            return this.pushRequirementsToChildWithPartial(node, Requirements.of(PartitioningProperties.unpartitioned()), child -> new TopNNode(this.idAllocator.getNextId(), (PlanNode)child, node.getCount(), node.getOrderBy(), node.getOrderings(), true), child -> new TopNNode(node.getId(), (PlanNode)child, node.getCount(), node.getOrderBy(), node.getOrderings(), false));
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, Void context) {
            return this.pushRequirementsToChild(node, Requirements.of(PartitioningProperties.unpartitioned()));
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, Void context) {
            return this.pushRequirementsToChildWithPartial(node, Requirements.of(PartitioningProperties.unpartitioned()), child -> new LimitNode(this.idAllocator.getNextId(), (PlanNode)child, node.getCount()), child -> ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child)));
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, Void context) {
            return this.pushRequirementsToChildWithPartial(node, Requirements.of(PartitioningProperties.unpartitioned()), child -> new DistinctLimitNode(this.idAllocator.getNextId(), (PlanNode)child, node.getLimit(), node.getHashSymbol()), child -> ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child)));
        }

        @Override
        public PlanWithProperties visitTableScan(TableScanNode node, Void context) {
            return new PlanWithProperties(node, ActualProperties.of(PartitioningProperties.arbitrary(), PlacementProperties.source()));
        }

        @Override
        public PlanWithProperties visitValues(ValuesNode node, Void context) {
            return new PlanWithProperties(node, ActualProperties.of(PartitioningProperties.unpartitioned(), PlacementProperties.anywhere()));
        }

        @Override
        public PlanWithProperties visitTableCommit(TableCommitNode node, Void context) {
            return this.pushRequirementsToChild(node, Requirements.of(PartitioningProperties.unpartitioned(), PlacementProperties.coordinatorOnly()));
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, Void context) {
            PlanNode rightNode;
            Preconditions.checkArgument((node.getType() != JoinNode.Type.RIGHT ? 1 : 0) != 0, (Object)"Expected RIGHT joins to be normalized to LEFT joins");
            PlanWithProperties left = node.getLeft().accept(this, context);
            PlanWithProperties right = node.getRight().accept(this, context);
            Optional<Symbol> leftHashSymbol = node.getLeftHashSymbol();
            Optional<Symbol> rightHashSymbol = node.getRightHashSymbol();
            List leftSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
            if (this.distributedJoins) {
                left = this.enforce(left, Requirements.of(PartitioningProperties.partitioned(leftSymbols, leftHashSymbol)));
                rightNode = this.enforce(right, Requirements.of(PartitioningProperties.partitioned(rightSymbols, rightHashSymbol))).getNode();
            } else {
                rightNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPLICATE, (List<Symbol>)ImmutableList.of(), Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)right.getNode()), right.getNode().getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(right.getNode().getOutputSymbols()));
            }
            return new PlanWithProperties(new JoinNode(node.getId(), node.getType(), left.getNode(), rightNode, node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol()), left.getProperties());
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, Void context) {
            PlanWithProperties source = node.getSource().accept(this, context);
            PlanWithProperties filteringSource = node.getFilteringSource().accept(this, context);
            PlanNode filteringSourceNode = source.getProperties().isPartitioned() ? new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPLICATE, (List<Symbol>)ImmutableList.of(), Optional.empty(), (List<PlanNode>)ImmutableList.of((Object)filteringSource.getNode()), filteringSource.getNode().getOutputSymbols(), (List<List<Symbol>>)ImmutableList.of(filteringSource.getNode().getOutputSymbols())) : this.enforce(filteringSource, Requirements.of(PartitioningProperties.unpartitioned())).getNode();
            return this.withNewChildren(node, source.getProperties(), (List<PlanNode>)ImmutableList.of((Object)source.getNode(), (Object)filteringSourceNode));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, Void context) {
            PlanWithProperties probeSource = node.getProbeSource().accept(this, context);
            if (this.distributedIndexJoins) {
                probeSource = this.enforce(probeSource, Requirements.of(PartitioningProperties.partitioned(Lists.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe), node.getProbeHashSymbol())));
            }
            return this.withNewChildren(node, probeSource.getProperties(), (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, Void context) {
            ArrayList<PlanNode> unpartitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> unpartitionedOutputLayouts = new ArrayList<List<Symbol>>();
            ArrayList<PlanNode> partitionedChildren = new ArrayList<PlanNode>();
            ArrayList<List<Symbol>> partitionedOutputLayouts = new ArrayList<List<Symbol>>();
            List<PlanNode> sources = node.getSources();
            for (int i = 0; i < sources.size(); ++i) {
                PlanWithProperties child = sources.get(i).accept(this, context);
                if (child.getProperties().isUnpartitioned()) {
                    unpartitionedChildren.add(child.getNode());
                    unpartitionedOutputLayouts.add(node.sourceOutputLayout(i));
                    continue;
                }
                partitionedChildren.add(child.getNode());
                partitionedOutputLayouts.add(node.sourceOutputLayout(i));
            }
            PlanNode result = null;
            if (!partitionedChildren.isEmpty()) {
                result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, (List<Symbol>)ImmutableList.of(), Optional.empty(), partitionedChildren, node.getOutputSymbols(), partitionedOutputLayouts);
                unpartitionedChildren.add(result);
                unpartitionedOutputLayouts.add(((PlanNode)result).getOutputSymbols());
            }
            if (unpartitionedChildren.size() > 1) {
                ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                    for (List list : unpartitionedOutputLayouts) {
                        mappings.put((Object)node.getOutputSymbols().get(i), list.get(i));
                    }
                }
                result = new UnionNode(node.getId(), unpartitionedChildren, (ListMultimap<Symbol, Symbol>)mappings.build());
            }
            return new PlanWithProperties(result, ActualProperties.of(PartitioningProperties.unpartitioned(), PlacementProperties.anywhere()));
        }

        private Requirements computePartitioningRequirements(List<Symbol> partitionKeys, Optional<Symbol> hashSymbol) {
            if (partitionKeys.isEmpty()) {
                return Requirements.of(PartitioningProperties.unpartitioned());
            }
            return Requirements.of(PartitioningProperties.partitioned(partitionKeys, hashSymbol));
        }

        private PlanWithProperties pushRequirementsToChildWithPartial(PlanNode node, Requirements requirements, Function<PlanNode, PlanNode> makePartial, Function<PlanNode, PlanNode> makeFinal) {
            PlanWithProperties child = ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null);
            return this.enforceWithPartial(child, requirements, makePartial, makeFinal);
        }

        private PlanWithProperties pushRequirementsToChild(PlanNode node, Requirements requirements) {
            PlanWithProperties source = ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null);
            return this.enforceWithPartial(source, requirements, child -> child, child -> ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child)));
        }

        private PlanWithProperties enforceWithPartial(PlanWithProperties child, Requirements requirements, Function<PlanNode, PlanNode> makePartial, Function<PlanNode, PlanNode> makeFinal) {
            PlanWithProperties enforced = this.enforce(child.getNode(), child.getProperties(), requirements, makePartial);
            return new PlanWithProperties(makeFinal.apply(enforced.getNode()), enforced.getProperties());
        }

        private PlanWithProperties enforce(PlanWithProperties plan, Requirements requirements) {
            return this.enforce(plan.getNode(), plan.getProperties(), requirements, child -> child);
        }

        private PlanWithProperties enforce(PlanNode node, ActualProperties properties, Requirements requirements, Function<PlanNode, PlanNode> makePartial) {
            if (requirements.isCoordinatorOnly() && !properties.isCoordinatorOnly()) {
                return new PlanWithProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), makePartial.apply(node)), ActualProperties.of(PartitioningProperties.unpartitioned(), PlacementProperties.coordinatorOnly()));
            }
            if (requirements.isUnpartitioned() && properties.isUnpartitioned()) {
                return new PlanWithProperties(node, properties);
            }
            if (requirements.isPartitioned() && properties.isPartitioned() && properties.getPartitioning().getKeys().equals(requirements.getPartitioning().get().getKeys())) {
                return new PlanWithProperties(node, properties);
            }
            if (properties.isPartitioned() && requirements.isUnpartitioned()) {
                return new PlanWithProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), makePartial.apply(node)), ActualProperties.of(PartitioningProperties.unpartitioned(), PlacementProperties.anywhere()));
            }
            if (requirements.isPartitionedOnKeys() && (properties.isUnpartitioned() || properties.isPartitioned() && !properties.getPartitioning().getKeys().equals(requirements.getPartitioning().get().getKeys()))) {
                return new PlanWithProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), makePartial.apply(node), requirements.getPartitioning().get().getKeys().get(), requirements.getPartitioning().get().getHashSymbol()), ActualProperties.of(requirements.getPartitioning().get(), PlacementProperties.anywhere()));
            }
            throw new UnsupportedOperationException(String.format("not supported: required %s, current %s", requirements, properties));
        }

        private PlanWithProperties propagateChildProperties(PlanNode node, PlanWithProperties child) {
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode()));
            return new PlanWithProperties(result, child.getProperties());
        }

        private PlanWithProperties withNewChildren(PlanNode node, ActualProperties properties, List<PlanNode> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children);
            return new PlanWithProperties(result, properties);
        }
    }
}

