/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SymbolAllocator {
    private final Map<Symbol, Type> symbols = new HashMap<Symbol, Type>();
    private int nextId;

    public Symbol newSymbol(String nameHint, Type type) {
        return this.newSymbol(nameHint, type, null);
    }

    public Symbol newHashSymbol() {
        return this.newSymbol("$hashValue", (Type)BigintType.BIGINT);
    }

    public Symbol newSymbol(String nameHint, Type type, String suffix) {
        String tail;
        Preconditions.checkNotNull((Object)nameHint, (Object)"name is null");
        nameHint = nameHint.toLowerCase(Locale.ENGLISH);
        int index = nameHint.lastIndexOf("_");
        if (index > 0 && (Ints.tryParse((String)(tail = nameHint.substring(index + 1))) != null || index == nameHint.length() - 1)) {
            nameHint = nameHint.substring(0, index);
        }
        String unique = nameHint;
        if (suffix != null) {
            unique = unique + "$" + suffix;
        }
        if (this.symbols.containsKey(new Symbol(unique))) {
            unique = unique + "_" + this.nextId();
        }
        Symbol symbol = new Symbol(unique);
        this.symbols.put(symbol, type);
        return symbol;
    }

    public Symbol newSymbol(Expression expression, Type type) {
        return this.newSymbol(expression, type, null);
    }

    public Symbol newSymbol(Expression expression, Type type, String suffix) {
        String nameHint = "expr";
        if (expression instanceof QualifiedNameReference) {
            nameHint = ((QualifiedNameReference)expression).getName().getSuffix();
        } else if (expression instanceof FunctionCall) {
            nameHint = ((FunctionCall)expression).getName().getSuffix();
        }
        return this.newSymbol(nameHint, type, suffix);
    }

    public Symbol newSymbol(Field field) {
        String nameHint = field.getName().orElse("field");
        return this.newSymbol(nameHint, field.getType());
    }

    public Map<Symbol, Type> getTypes() {
        return this.symbols;
    }

    private int nextId() {
        return this.nextId++;
    }
}

