/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.optimizations.AddExchanges;
import com.facebook.presto.sql.planner.optimizations.BeginTableWrite;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.planner.optimizations.CountConstantOptimizer;
import com.facebook.presto.sql.planner.optimizations.HashGenerationOptimizer;
import com.facebook.presto.sql.planner.optimizations.ImplementSampleAsFilter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.optimizations.LimitPushDown;
import com.facebook.presto.sql.planner.optimizations.MergeProjections;
import com.facebook.presto.sql.planner.optimizations.MetadataQueryOptimizer;
import com.facebook.presto.sql.planner.optimizations.NormalizeJoinOrder;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PredicatePushDown;
import com.facebook.presto.sql.planner.optimizations.PruneRedundantProjections;
import com.facebook.presto.sql.planner.optimizations.PruneUnreferencedOutputs;
import com.facebook.presto.sql.planner.optimizations.SetFlatteningOptimizer;
import com.facebook.presto.sql.planner.optimizations.SimplifyExpressions;
import com.facebook.presto.sql.planner.optimizations.UnaliasSymbolReferences;
import com.facebook.presto.sql.planner.optimizations.WindowFilterPushDown;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import javax.inject.Provider;

public class PlanOptimizersFactory
implements Provider<List<PlanOptimizer>> {
    private final List<PlanOptimizer> optimizers;

    @Inject
    public PlanOptimizersFactory(Metadata metadata, SqlParser sqlParser, SplitManager splitManager, IndexManager indexManager, FeaturesConfig featuresConfig) {
        this(metadata, sqlParser, splitManager, indexManager, featuresConfig, false);
    }

    public PlanOptimizersFactory(Metadata metadata, SqlParser sqlParser, SplitManager splitManager, IndexManager indexManager, FeaturesConfig featuresConfig, boolean forceSingleNode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new PlanOptimizer[]{new ImplementSampleAsFilter(), new CanonicalizeExpressions(), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new PruneRedundantProjections(), new SetFlatteningOptimizer(), new LimitPushDown(), new PredicatePushDown(metadata, sqlParser, splitManager), new PredicatePushDown(metadata, sqlParser, splitManager), new MergeProjections(), new SimplifyExpressions(metadata, sqlParser), new UnaliasSymbolReferences(), new IndexJoinOptimizer(indexManager), new CountConstantOptimizer(), new WindowFilterPushDown(), new HashGenerationOptimizer(featuresConfig.isOptimizeHashGeneration()), new MergeProjections(), new PruneUnreferencedOutputs(), new PruneRedundantProjections()});
        if (featuresConfig.isOptimizeMetadataQueries()) {
            builder.add((Object)new MetadataQueryOptimizer(metadata, splitManager));
        }
        builder.add((Object)new NormalizeJoinOrder());
        builder.add((Object)new BeginTableWrite(metadata));
        if (!forceSingleNode) {
            builder.add((Object)new AddExchanges(metadata, featuresConfig.isDistributedIndexJoinsEnabled(), featuresConfig.isDistributedJoinsEnabled()));
        }
        this.optimizers = builder.build();
    }

    public synchronized List<PlanOptimizer> get() {
        return this.optimizers;
    }
}

