/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.block.BlockUtils;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.GenericCursorProcessor;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.InMemoryExchangeSourceOperator;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.SampleOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TableCommitOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLookupSourceSupplier;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final PageSinkManager pageSinkManager;
    private final Supplier<ExchangeClient> exchangeClientSupplier;
    private final ExpressionCompiler compiler;
    private final boolean interpreterEnabled;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;
    private final int writerCount;

    @Inject
    public LocalExecutionPlanner(Metadata metadata, SqlParser sqlParser, PageSourceProvider pageSourceProvider, IndexManager indexManager, PageSinkManager pageSinkManager, Supplier<ExchangeClient> exchangeClientSupplier, ExpressionCompiler compiler, IndexJoinLookupStats indexJoinLookupStats, CompilerConfig compilerConfig, TaskManagerConfig taskManagerConfig) {
        Preconditions.checkNotNull((Object)compilerConfig, (Object)"compilerConfig is null");
        this.pageSourceProvider = (PageSourceProvider)Preconditions.checkNotNull((Object)pageSourceProvider, (Object)"pageSourceProvider is null");
        this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.sqlParser = (SqlParser)Preconditions.checkNotNull((Object)sqlParser, (Object)"sqlParser is null");
        this.pageSinkManager = (PageSinkManager)Preconditions.checkNotNull((Object)pageSinkManager, (Object)"pageSinkManager is null");
        this.compiler = (ExpressionCompiler)Preconditions.checkNotNull((Object)compiler, (Object)"compiler is null");
        this.indexJoinLookupStats = (IndexJoinLookupStats)Preconditions.checkNotNull((Object)indexJoinLookupStats, (Object)"indexJoinLookupStats is null");
        this.maxIndexMemorySize = ((TaskManagerConfig)Preconditions.checkNotNull((Object)taskManagerConfig, (Object)"taskManagerConfig is null")).getMaxTaskIndexMemoryUsage();
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.writerCount = taskManagerConfig.getWriterCount();
        this.interpreterEnabled = compilerConfig.isInterpreterEnabled();
    }

    public LocalExecutionPlan plan(Session session, PlanNode plan, List<Symbol> outputLayout, Map<Symbol, Type> types, OutputFactory outputOperatorFactory) {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(session, types);
        PhysicalOperation physicalOperation = this.enforceLayout(outputLayout, context, plan.accept(new Visitor(session), context));
        DriverFactory driverFactory = new DriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), physicalOperation.getTypes())).build(), context.getDriverInstanceCount());
        context.addDriverFactory(driverFactory);
        return new LocalExecutionPlan(context.getDriverFactories());
    }

    private PhysicalOperation enforceLayout(List<Symbol> outputLayout, LocalExecutionPlanContext context, PhysicalOperation physicalOperation) {
        boolean projectionMatchesOutput = physicalOperation.getLayout().entrySet().stream().sorted(Ordering.natural().onResultOf(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableCollectors.toImmutableList()).equals(outputLayout);
        if (!projectionMatchesOutput) {
            IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(outputLayout, physicalOperation.getLayout(), context.getTypes());
            FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), new GenericPageProcessor(FilterFunctions.TRUE_FUNCTION, mappings.getProjections()), LocalExecutionPlanner.toTypes(mappings.getProjections()));
            physicalOperation = new PhysicalOperation(operatorFactory, mappings.getOutputLayout(), physicalOperation);
        }
        return physicalOperation;
    }

    public static List<Type> toTypes(List<ProjectionFunction> projections) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            builder.add((Object)projection.getType());
        }
        return builder.build();
    }

    private static TableCommitOperator.TableCommitter createTableCommitter(TableCommitNode node, final Metadata metadata) {
        final TableWriterNode.WriterTarget target = node.getTarget();
        return new TableCommitOperator.TableCommitter(){

            @Override
            public void commitTable(Collection<Slice> fragments) {
                if (target instanceof TableWriterNode.CreateHandle) {
                    metadata.commitCreateTable(((TableWriterNode.CreateHandle)target).getHandle(), fragments);
                } else if (target instanceof TableWriterNode.InsertHandle) {
                    metadata.commitInsert(((TableWriterNode.InsertHandle)target).getHandle(), fragments);
                } else {
                    throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
                }
            }
        };
    }

    private static IdentityProjectionInfo computeIdentityMapping(List<Symbol> symbols, Map<Symbol, Integer> inputLayout, Map<Symbol, Type> types) {
        HashMap<Symbol, Integer> outputMappings = new HashMap<Symbol, Integer>();
        ArrayList<ProjectionFunction> projections = new ArrayList<ProjectionFunction>();
        int channel = 0;
        for (Symbol symbol : symbols) {
            ProjectionFunction function = ProjectionFunctions.singleColumn(types.get(symbol), inputLayout.get(symbol));
            projections.add(function);
            if (outputMappings.containsKey(symbol)) continue;
            outputMappings.put(symbol, channel);
            ++channel;
        }
        return new IdentityProjectionInfo((Map<Symbol, Integer>)ImmutableMap.copyOf(outputMappings), projections);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static java.util.function.Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            this.operatorFactories = ImmutableList.of((Object)operatorFactory);
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, PhysicalOperation source) {
            Preconditions.checkNotNull((Object)operatorFactory, (Object)"operatorFactory is null");
            Preconditions.checkNotNull(layout, (Object)"layout is null");
            Preconditions.checkNotNull((Object)source, (Object)"source is null");
            this.operatorFactories = ImmutableList.builder().addAll(source.getOperatorFactories()).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private static class IdentityProjectionInfo {
        private final Map<Symbol, Integer> layout;
        private final List<ProjectionFunction> projections;

        public IdentityProjectionInfo(Map<Symbol, Integer> outputLayout, List<ProjectionFunction> projections) {
            this.layout = (Map)Preconditions.checkNotNull(outputLayout, (Object)"outputLayout is null");
            this.projections = (List)Preconditions.checkNotNull(projections, (Object)"projections is null");
        }

        public Map<Symbol, Integer> getOutputLayout() {
            return this.layout;
        }

        public List<ProjectionFunction> getProjections() {
            return this.projections;
        }
    }

    private class Visitor
    extends PlanVisitor<LocalExecutionPlanContext, PhysicalOperation> {
        private final Session session;

        private Visitor(Session session) {
            this.session = session;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), (Supplier<ExchangeClient>)LocalExecutionPlanner.this.exchangeClientSupplier, types);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableCollectors.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 1000000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableCollectors.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderBy();
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableCollectors.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Symbol> orderBySymbols = node.getOrderBy();
            ImmutableList partitionChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableCollectors.toImmutableList());
            Optional<Integer> frameStartChannel = Optional.empty();
            Optional<Integer> frameEndChannel = Optional.empty();
            if (node.getFrame().getStartValue().isPresent()) {
                frameStartChannel = Optional.of(source.getLayout().get(node.getFrame().getStartValue().get()));
            }
            if (node.getFrame().getEndValue().isPresent()) {
                frameEndChannel = Optional.of(source.getLayout().get(node.getFrame().getEndValue().get()));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression expression : entry.getValue().getArguments()) {
                    Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol2 = entry.getKey();
                Signature signature = node.getSignatures().get(symbol2);
                windowFunctionsBuilder.add((Object)LocalExecutionPlanner.this.metadata.getExactFunction(signature).bindWindowFunction((List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol2);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableList windowFunctions = windowFunctionsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol2 : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol2, (Object)source.getLayout().get(symbol2));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol4 : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol4, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctions, (List<Integer>)partitionChannels, sortChannels, sortOrder, node.getFrame().getType(), node.getFrame().getStartType(), frameStartChannel, node.getFrame().getEndType(), frameEndChannel, 1000000);
            return new PhysicalOperation(windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderings().get(symbol));
            }
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders, node.isPartial());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            List orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderings().get(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), source.getTypes(), node.getCount());
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel);
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            if (node.getGroupBy().isEmpty()) {
                return this.planGlobalAggregation(context.getNextOperatorId(), node, source);
            }
            return this.planGroupByAggregation(node, source, context);
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), source.getTypes(), channels, hashChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            if (node.getSampleType() == SampleNode.Type.POISSONIZED) {
                PhysicalOperation source = node.getSource().accept(this, context);
                SampleOperator.SampleOperatorFactory operatorFactory = new SampleOperator.SampleOperatorFactory(context.getNextOperatorId(), node.getSampleRatio(), node.isRescaled(), source.getTypes());
                Preconditions.checkState((boolean)node.getSampleWeightSymbol().isPresent(), (Object)"sample weight symbol missing");
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            ArrayList<Expression> projectionExpressions = new ArrayList<Expression>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                Symbol symbol = node.getOutputSymbols().get(i);
                projectionExpressions.add((Expression)new QualifiedNameReference(symbol.toQualifiedName()));
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, filterExpression, projectionExpressions, outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            BooleanLiteral filterExpression;
            PlanNode sourceNode;
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = filterNode.getPredicate();
            } else {
                sourceNode = node.getSource();
                filterExpression = BooleanLiteral.TRUE_LITERAL;
            }
            List<Expression> projectionExpressions = node.getExpressions();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, sourceNode, (Expression)filterExpression, projectionExpressions, outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNode sourceNode, Expression filterExpression, List<Expression> projectionExpressions, List<Symbol> outputSymbols) {
            LinkedHashMap<Integer, Type> sourceTypes;
            LinkedHashMap<Symbol, Integer> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    Type type = (Type)Preconditions.checkNotNull((Object)context.getTypes().get(symbol), (String)"No type for symbol %s", (Object[])new Object[]{symbol});
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTypes());
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
            Expression rewrittenFilter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)filterExpression);
            ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
            for (Expression projection : projectionExpressions) {
                rewrittenProjections.add(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)projection));
            }
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, sourceTypes, Iterables.concat(Collections.singleton(rewrittenFilter), rewrittenProjections));
            RowExpression traslatedFilter = SqlToRowExpressionTranslator.translate(rewrittenFilter, expressionTypes, LocalExecutionPlanner.this.metadata, this.session, true);
            List<RowExpression> translatedProjections = SqlToRowExpressionTranslator.translate(rewrittenProjections, expressionTypes, LocalExecutionPlanner.this.metadata, this.session, true);
            try {
                if (columns != null) {
                    CursorProcessor cursorProcessor = LocalExecutionPlanner.this.compiler.compileCursorProcessor(traslatedFilter, translatedProjections, sourceNode.getId());
                    PageProcessor pageProcessor = LocalExecutionPlanner.this.compiler.compilePageProcessor(traslatedFilter, translatedProjections);
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, columns, Lists.transform(rewrittenProjections, (Function)Functions.forMap(expressionTypes)));
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                PageProcessor processor = LocalExecutionPlanner.this.compiler.compilePageProcessor(traslatedFilter, translatedProjections);
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), processor, Lists.transform(rewrittenProjections, (Function)Functions.forMap(expressionTypes)));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
            catch (RuntimeException e) {
                Object operatorFactory;
                if (!LocalExecutionPlanner.this.interpreterEnabled) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed and interpreter is disabled", (Throwable)e);
                }
                log.error((Throwable)e, "Compile failed for filter=%s projections=%s sourceTypes=%s error=%s", new Object[]{filterExpression, projectionExpressions, sourceTypes, e});
                FilterFunction filterFunction = filterExpression != BooleanLiteral.TRUE_LITERAL ? new InterpretedFilterFunction(filterExpression, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, context.getSession()) : FilterFunctions.TRUE_FUNCTION;
                ArrayList<ProjectionFunction> projectionFunctions = new ArrayList<ProjectionFunction>();
                for (Expression expression : projectionExpressions) {
                    ProjectionFunction function;
                    if (expression instanceof QualifiedNameReference) {
                        Symbol reference = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                        function = ProjectionFunctions.singleColumn(context.getTypes().get(reference), (Integer)sourceLayout.get(reference));
                    } else {
                        function = new InterpretedProjectionFunction(expression, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, context.getSession());
                    }
                    projectionFunctions.add(function);
                }
                if (columns != null) {
                    operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, new GenericCursorProcessor(filterFunction, projectionFunctions), new GenericPageProcessor(filterFunction, projectionFunctions), columns, LocalExecutionPlanner.toTypes(projectionFunctions));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), new GenericPageProcessor(filterFunction, projectionFunctions), LocalExecutionPlanner.toTypes(projectionFunctions));
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
        }

        private Map<Integer, Type> getInputTypes(Map<Symbol, Integer> layout, List<Type> types) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            for (Integer input : ImmutableSet.copyOf(layout.values())) {
                Type type = types.get(input);
                inputTypes.put((Object)input, (Object)type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, types, columns);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            ArrayList<Type> outputTypes = new ArrayList<Type>();
            for (Symbol symbol : node.getOutputSymbols()) {
                Type type = (Type)Preconditions.checkNotNull((Object)context.getTypes().get(symbol), (String)"No type for symbol %s", (Object[])new Object[]{symbol});
                outputTypes.add(type);
            }
            PageBuilder pageBuilder = new PageBuilder(outputTypes);
            for (List<Expression> list : node.getRows()) {
                pageBuilder.declarePosition();
                IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), (Iterable<? extends Expression>)ImmutableList.copyOf(list));
                for (int i = 0; i < list.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(list.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate(0, new Block[0]);
                    BlockUtils.appendObject((Type)outputTypes.get(i), pageBuilder.getBlockBuilder(i), result);
                }
            }
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), outputTypes, (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation(valuesOperatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)context.getTypes().get(symbol));
            }
            ImmutableList unnestSymbols = ImmutableList.copyOf(node.getUnnestSymbols().keySet());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)context.getTypes().get(symbol));
            }
            List replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List unnestChannels = LocalExecutionPlanner.getChannelsForSymbols((List)unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (Symbol symbol : unnestSymbols) {
                for (Symbol unnestedSymbol : node.getUnnestSymbols().get(symbol)) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add((Object)FluentIterable.from((Iterable)potentialProbeInputs).toSet());
                }
                remappedProbeKeyChannelsBuilder.add(Iterables.getFirst((Iterable)potentialProbeInputs, null));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            java.util.function.Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> Visitor.lambda$visitIndexSource$44((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (Function)Functions.forMap(node.getAssignments()));
            Index index = LocalExecutionPlanner.this.indexManager.getIndex(node.getIndexHandle(), lookupSchema, outputSchema);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, types, probeKeyNormalizer);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            ImmutableSet indexJoinSymbols = FluentIterable.from(node.getCriteria()).transform(IndexJoinNode.EquiJoinClause::getIndex).toSet();
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            Optional<Integer> probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource));
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            Optional<Integer> indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource));
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            ImmutableSet lookupSourceInputChannels = FluentIterable.from(node.getCriteria()).filter(Predicates.compose((Predicate)Predicates.in(indexSymbolsNeededBySource), IndexJoinNode.EquiJoinClause::getIndex)).transform(IndexJoinNode.EquiJoinClause::getProbe).transform(Functions.forMap(probeKeyLayout)).toSet();
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)FluentIterable.from(node.getCriteria()).filter(Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.in(indexSymbolsNeededBySource)), IndexJoinNode.EquiJoinClause::getIndex)).transform(IndexJoinNode.EquiJoinClause::getProbe).transform(Functions.forMap(probeKeyLayout)).toList());
                int[] nonLookupOutputChannels = Ints.toArray((Collection)FluentIterable.from(node.getCriteria()).filter(Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.in(indexSymbolsNeededBySource)), IndexJoinNode.EquiJoinClause::getIndex)).transform(IndexJoinNode.EquiJoinClause::getIndex).transform(Functions.forMap(indexSource.getLayout())).toList());
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes()));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextOperatorId(), indexContext.isInputDriver(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceSupplier indexLookupSourceSupplier = new IndexLookupSourceSupplier((Set<Integer>)lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.innerJoin(context.getNextOperatorId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels, probeHashChannel);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.outerJoin(context.getNextOperatorId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels, probeHashChannel);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: {
                    return this.createJoinOperator(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), context);
                }
                case RIGHT: {
                    return this.createJoinOperator(node, node.getRight(), rightSymbols, node.getRightHashSymbol(), node.getLeft(), leftSymbols, node.getLeftHashSymbol(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createJoinOperator(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = probeNode.accept(this, context);
            ImmutableList probeChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            Optional<Integer> probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource));
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            Optional<Integer> buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource));
            HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTypes(), (List<Integer>)buildChannels, buildHashChannel, 100000);
            LookupSourceSupplier lookupSourceSupplier = hashBuilderOperatorFactory.getLookupSourceSupplier();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : buildSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            OperatorFactory operator = this.createJoinOperator(node.getType(), lookupSourceSupplier, probeSource.getTypes(), (List<Integer>)probeChannels, probeHashChannel, context);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
        }

        private OperatorFactory createJoinOperator(JoinNode.Type type, LookupSourceSupplier lookupSourceSupplier, List<Type> probeTypes, List<Integer> probeJoinChannels, Optional<Integer> probeHashChannel, LocalExecutionPlanContext context) {
            switch (type) {
                case INNER: {
                    return LookupJoinOperators.innerJoin(context.getNextOperatorId(), lookupSourceSupplier, probeTypes, probeJoinChannels, probeHashChannel);
                }
                case LEFT: 
                case RIGHT: {
                    return LookupJoinOperators.outerJoin(context.getNextOperatorId(), lookupSourceSupplier, probeTypes, probeJoinChannels, probeHashChannel);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)type));
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getSource().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            Optional<Integer> probeHashChannel = node.getSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource));
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), buildSource.getTypes(), buildChannel, buildHashChannel, 100000);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), setProvider, probeSource.getTypes(), probeChannel, probeHashChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings, probeSource);
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation exchange = this.createInMemoryExchange(node.getSource(), context);
            Optional<Integer> sampleWeightChannel = node.getSampleWeightSymbol().map(exchange::symbolToChannel);
            context.setDriverInstanceCount(LocalExecutionPlanner.this.writerCount);
            List inputChannels = (List)node.getColumns().stream().map(exchange::symbolToChannel).collect(ImmutableCollectors.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, sampleWeightChannel);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, exchange);
        }

        private PhysicalOperation createInMemoryExchange(PlanNode node, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = node.accept(this, subContext);
            InMemoryExchange exchange = new InMemoryExchange(this.getSourceOperatorTypes(node, context.getTypes()));
            ImmutableList factories = ImmutableList.builder().addAll((Iterable)source.getOperatorFactories()).add((Object)exchange.createSinkFactory(subContext.getNextOperatorId())).build();
            context.addDriverFactory(new DriverFactory(subContext.isInputDriver(), false, (List<OperatorFactory>)factories));
            exchange.noMoreSinkFactories();
            context.setInputDriver(false);
            InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory factory = new InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory(context.getNextOperatorId(), exchange);
            return new PhysicalOperation(factory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitTableCommit(TableCommitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            TableCommitOperator.TableCommitOperatorFactory operatorFactory = new TableCommitOperator.TableCommitOperatorFactory(context.getNextOperatorId(), LocalExecutionPlanner.createTableCommitter(node, LocalExecutionPlanner.this.metadata));
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)0);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            InMemoryExchange inMemoryExchange = new InMemoryExchange(types);
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                List<Symbol> expectedLayout = node.sourceOutputLayout(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                PhysicalOperation source = subplan.accept(this, subContext);
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                boolean projectionMatchesOutput = source.getLayout().entrySet().stream().sorted(Ordering.natural().onResultOf(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableCollectors.toImmutableList()).equals(expectedLayout);
                if (!projectionMatchesOutput) {
                    IdentityProjectionInfo mappings = LocalExecutionPlanner.computeIdentityMapping(expectedLayout, source.getLayout(), context.getTypes());
                    operatorFactories.add(new FilterAndProjectOperator.FilterAndProjectOperatorFactory(subContext.getNextOperatorId(), new GenericPageProcessor(FilterFunctions.TRUE_FUNCTION, mappings.getProjections()), LocalExecutionPlanner.toTypes(mappings.getProjections())));
                }
                operatorFactories.add(inMemoryExchange.createSinkFactory(subContext.getNextOperatorId()));
                DriverFactory driverFactory = new DriverFactory(subContext.isInputDriver(), false, operatorFactories);
                context.addDriverFactory(driverFactory);
            }
            inMemoryExchange.noMoreSinkFactories();
            context.setInputDriver(false);
            return new PhysicalOperation(new InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory(context.getNextOperatorId(), inMemoryExchange), (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, Map<Symbol, Type> types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, Map<Symbol, Type> types) {
            return (List)symbols.stream().map(types::get).collect(ImmutableCollectors.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, Signature function, FunctionCall call, @Nullable Symbol mask, Optional<Symbol> sampleWeight, double confidence) {
            ArrayList<Integer> arguments = new ArrayList<Integer>();
            for (Expression argument : call.getArguments()) {
                Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)argument).getName());
                arguments.add(source.getLayout().get(argumentSymbol));
            }
            Optional<Integer> maskChannel = Optional.empty();
            if (mask != null) {
                maskChannel = Optional.of(source.getLayout().get(mask));
            }
            Optional<Integer> sampleWeightChannel = Optional.empty();
            if (sampleWeight.isPresent()) {
                sampleWeightChannel = Optional.of(source.getLayout().get(sampleWeight.get()));
            }
            return LocalExecutionPlanner.this.metadata.getExactFunction(function).getAggregationFunction().bind(arguments, maskChannel, sampleWeightChannel, confidence);
        }

        private PhysicalOperation planGlobalAggregation(int operatorId, AggregationNode node, PhysicalOperation source) {
            int outputChannel = 0;
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, node.getFunctions().get(symbol), entry.getValue(), node.getMasks().get(entry.getKey()), node.getSampleWeight(), node.getConfidence()));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(operatorId, node.getStep(), accumulatorFactories);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, LocalExecutionPlanContext context) {
            List<Symbol> groupBySymbols = node.getGroupBy();
            ArrayList aggregationOutputSymbols = new ArrayList();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, FunctionCall> entry2 : node.getAggregations().entrySet()) {
                Iterator symbol = entry2.getKey();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, node.getFunctions().get(symbol), entry2.getValue(), node.getMasks().get(entry2.getKey()), node.getSampleWeight(), node.getConfidence()));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            if (node.getHashSymbol().isPresent()) {
                outputMappings.put((Object)node.getHashSymbol().get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List list = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableCollectors.toImmutableList());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(context.getNextOperatorId(), list, groupByChannels, node.getStep(), accumulatorFactories, hashChannel, 10000, LocalExecutionPlanner.this.maxPartialAggregationMemorySize);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private static /* synthetic */ RecordSet lambda$visitIndexSource$44(List list, List list2, RecordSet recordSet) {
            if (!list.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(recordSet, list);
            }
            return new MappedRecordSet(recordSet, list2);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;

        public LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(driverFactories, (Object)"driverFactories is null")));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Preconditions.checkNotNull(indexLookupToProbeInput, (Object)"indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final Session session;
        private final Map<Symbol, Type> types;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private int driverInstanceCount = 1;

        public LocalExecutionPlanContext(Session session, Map<Symbol, Type> types) {
            this(session, types, new ArrayList<DriverFactory>(), Optional.empty());
        }

        private LocalExecutionPlanContext(Session session, Map<Symbol, Type> types, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext) {
            this.session = session;
            this.types = types;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
        }

        public void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add((DriverFactory)Preconditions.checkNotNull((Object)driverFactory, (Object)"driverFactory is null"));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.session;
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.session, this.types, this.driverFactories, this.indexSourceContext);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.session, this.types, this.driverFactories, Optional.of(indexSourceContext));
        }

        public int getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            this.driverInstanceCount = driverInstanceCount;
        }
    }
}

