/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class NullIfCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        CompilerContext context = generatorContext.getContext();
        RowExpression first = arguments.get(0);
        RowExpression second = arguments.get(1);
        LabelNode notMatch = new LabelNode("notMatch");
        Block block = new Block(context).comment("check if first arg is null").append(generatorContext.generate(first)).append(ByteCodeUtils.ifWasNullPopAndGoto(context, notMatch, Void.TYPE, new Class[0]));
        Type firstType = first.getType();
        Type secondType = second.getType();
        Type commonType = FunctionRegistry.getCommonSuperType(firstType, secondType).get();
        FunctionInfo equalsFunction = generatorContext.getRegistry().resolveOperator(OperatorType.EQUAL, (List<? extends Type>)ImmutableList.of((Object)firstType, (Object)secondType));
        ByteCodeNode equalsCall = generatorContext.generateCall(equalsFunction, (List<ByteCodeNode>)ImmutableList.of((Object)this.cast(generatorContext, new Block(context).dup(firstType.getJavaType()), firstType, commonType), (Object)this.cast(generatorContext, generatorContext.generate(second), secondType, commonType)));
        Block conditionBlock = new Block(context).append(equalsCall).append(ByteCodeUtils.ifWasNullClearPopAndGoto(context, notMatch, Void.TYPE, Boolean.TYPE));
        Block trueBlock = new Block(context).putVariable("wasNull", true).pop(first.getType().getJavaType()).pushJavaDefault(first.getType().getJavaType());
        block.append(new IfStatement(context, conditionBlock, trueBlock, notMatch));
        return block;
    }

    private ByteCodeNode cast(ByteCodeGeneratorContext generatorContext, ByteCodeNode argument, Type fromType, Type toType) {
        FunctionInfo function = generatorContext.getRegistry().getCoercion(fromType, toType);
        return generatorContext.generateCall(function, (List<ByteCodeNode>)ImmutableList.of((Object)argument));
    }
}

