/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class FunctionCallCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        FunctionRegistry registry = context.getRegistry();
        FunctionInfo function = registry.getExactFunction(signature);
        if (function == null) {
            function = registry.resolveFunction(QualifiedName.of((String)signature.getName(), (String[])new String[0]), signature.getArgumentTypes(), false);
        }
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Function %s not found", (Object[])new Object[]{signature});
        ArrayList<ByteCodeNode> argumentsByteCode = new ArrayList<ByteCodeNode>();
        for (RowExpression argument : arguments) {
            argumentsByteCode.add(context.generate(argument));
        }
        return context.generateCall(function, argumentsByteCode);
    }
}

