/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.system.SystemSplitManager;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.Util;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.split.ConnectorAwareSplitSource;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class SplitManager {
    private final ConcurrentMap<String, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<String, ConnectorSplitManager>();
    private final SystemSplitManager systemSplitManager;

    @Inject
    public SplitManager(SystemSplitManager systemSplitManager) {
        this.systemSplitManager = (SystemSplitManager)Preconditions.checkNotNull((Object)systemSplitManager, (Object)"systemSplitManager is null");
    }

    public void addConnectorSplitManager(String connectorId, ConnectorSplitManager connectorSplitManager) {
        Preconditions.checkState((this.splitManagers.putIfAbsent(connectorId, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public PartitionResult getPartitions(TableHandle table, Optional<TupleDomain<ColumnHandle>> tupleDomain) {
        TupleDomain<ColumnHandle> domain = tupleDomain.orElse((TupleDomain<ColumnHandle>)TupleDomain.all());
        ConnectorPartitionResult result = domain.isNone() ? new ConnectorPartitionResult((List)ImmutableList.of(), Util.toConnectorDomain(domain)) : this.getConnectorSplitManager(table).getPartitions(table.getConnectorHandle(), Util.toConnectorDomain(domain));
        return new PartitionResult(table.getConnectorId(), result);
    }

    public SplitSource getPartitionSplits(TableHandle handle, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return new ConnectorAwareSplitSource(handle.getConnectorId(), (ConnectorSplitSource)new FixedSplitSource(handle.getConnectorId(), (Iterable)ImmutableList.of()));
        }
        ConnectorTableHandle table = handle.getConnectorHandle();
        ConnectorSplitSource source = this.getConnectorSplitManager(handle).getPartitionSplits(table, Lists.transform(partitions, Partition::getConnectorPartition));
        return new ConnectorAwareSplitSource(handle.getConnectorId(), source);
    }

    private ConnectorSplitManager getConnectorSplitManager(TableHandle handle) {
        String connectorId = handle.getConnectorId();
        if (connectorId.equals("system")) {
            return this.systemSplitManager;
        }
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object[])new Object[]{connectorId});
        return result;
    }
}

