/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class SampledSplitSource
implements SplitSource {
    private final SplitSource splitSource;
    private final double sampleRatio;

    public SampledSplitSource(SplitSource splitSource, double sampleRatio) {
        this.splitSource = (SplitSource)Preconditions.checkNotNull((Object)splitSource, (Object)"dataSource is null");
        this.sampleRatio = sampleRatio;
    }

    @Override
    @Nullable
    public String getDataSourceName() {
        return this.splitSource.getDataSourceName();
    }

    @Override
    public List<Split> getNextBatch(int maxSize) throws InterruptedException {
        return (List)this.splitSource.getNextBatch(maxSize).stream().filter(input -> ThreadLocalRandom.current().nextDouble() < this.sampleRatio).collect(ImmutableCollectors.toImmutableList());
    }

    @Override
    public void close() {
        this.splitSource.close();
    }

    @Override
    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

