/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.testing;

import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.ServerMainModule;
import com.facebook.presto.server.testing.FileUtils;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.discovery.client.Announcer;
import io.airlift.discovery.client.DiscoveryModule;
import io.airlift.discovery.client.ServiceAnnouncement;
import io.airlift.discovery.client.ServiceSelectorManager;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.event.client.InMemoryEventModule;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import java.io.Closeable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class TestingPrestoServer
implements Closeable {
    public static final String TEST_CATALOG = "default";
    private final Path baseDataDir = Files.createTempDirectory("PrestoTest", new FileAttribute[0]);
    private final LifeCycleManager lifeCycleManager;
    private final PluginManager pluginManager;
    private final ConnectorManager connectorManager;
    private final TestingHttpServer server;
    private final Metadata metadata;
    private final InternalNodeManager nodeManager;
    private final ServiceSelectorManager serviceSelectorManager;
    private final Announcer announcer;
    private QueryManager queryManager;

    public TestingPrestoServer() throws Exception {
        this((List<Module>)ImmutableList.of());
    }

    public TestingPrestoServer(List<Module> additionalModules) throws Exception {
        this(true, (Map<String, String>)ImmutableMap.of(), null, null, additionalModules);
    }

    public TestingPrestoServer(boolean coordinator, Map<String, String> properties, String environment, URI discoveryUri, List<Module> additionalModules) throws Exception {
        ImmutableMap.Builder serverProperties = ImmutableMap.builder().putAll(properties).put((Object)"coordinator", (Object)String.valueOf(coordinator)).put((Object)"presto.version", (Object)"testversion").put((Object)"analyzer.experimental-syntax-enabled", (Object)"true");
        if (coordinator) {
            serverProperties.put((Object)"failure-detector.enabled", (Object)"false");
        }
        ImmutableList.Builder modules = ImmutableList.builder().add((Object)new TestingNodeModule(Optional.fromNullable((Object)environment))).add((Object)new TestingHttpServerModule()).add((Object)new JsonModule()).add((Object)new JaxrsModule(true)).add((Object)new MBeanModule()).add((Object)new TestingJmxModule()).add((Object)new InMemoryEventModule()).add((Object)new TraceTokenModule()).add((Object)new ServerMainModule(new SqlParserOptions()));
        if (discoveryUri != null) {
            Preconditions.checkNotNull((Object)environment, (Object)"environment required when discoveryUri is present");
            serverProperties.put((Object)"discovery.uri", (Object)discoveryUri.toString());
            modules.add((Object)new DiscoveryModule());
        } else {
            modules.add((Object)new TestingDiscoveryModule());
        }
        modules.addAll(additionalModules);
        Bootstrap app = new Bootstrap((Iterable)modules.build());
        HashMap<String, String> optionalProperties = new HashMap<String, String>();
        if (environment != null) {
            optionalProperties.put("node.environment", environment);
        }
        Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties((Map)serverProperties.build()).setOptionalConfigurationProperties(optionalProperties).initialize();
        ((Announcer)injector.getInstance(Announcer.class)).start();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.queryManager = (QueryManager)injector.getInstance(QueryManager.class);
        this.pluginManager = (PluginManager)injector.getInstance(PluginManager.class);
        this.connectorManager = (ConnectorManager)injector.getInstance(ConnectorManager.class);
        this.server = (TestingHttpServer)injector.getInstance(TestingHttpServer.class);
        this.metadata = (Metadata)injector.getInstance(Metadata.class);
        this.nodeManager = (InternalNodeManager)injector.getInstance(InternalNodeManager.class);
        this.serviceSelectorManager = (ServiceSelectorManager)injector.getInstance(ServiceSelectorManager.class);
        this.announcer = (Announcer)injector.getInstance(Announcer.class);
        this.announcer.forceAnnounce();
        this.refreshNodes();
    }

    @Override
    public void close() {
        try {
            if (this.lifeCycleManager != null) {
                this.lifeCycleManager.stop();
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            FileUtils.deleteRecursively(this.baseDataDir);
        }
    }

    public void installPlugin(Plugin plugin) {
        this.pluginManager.installPlugin(plugin);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public void createCatalog(String catalogName, String connectorName) {
        this.createCatalog(catalogName, connectorName, (Map<String, String>)ImmutableMap.of());
    }

    public void createCatalog(String catalogName, String connectorName, Map<String, String> properties) {
        this.connectorManager.createConnection(catalogName, connectorName, properties);
        TestingPrestoServer.updateDatasourcesAnnouncement(this.announcer, catalogName);
    }

    public Path getBaseDataDir() {
        return this.baseDataDir;
    }

    public URI getBaseUrl() {
        return this.server.getBaseUrl();
    }

    public URI resolve(String path) {
        return this.server.getBaseUrl().resolve(path);
    }

    public HostAndPort getAddress() {
        return HostAndPort.fromParts((String)this.getBaseUrl().getHost(), (int)this.getBaseUrl().getPort());
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public final AllNodes refreshNodes() {
        this.serviceSelectorManager.forceRefresh();
        this.nodeManager.refreshNodes();
        return this.nodeManager.getAllNodes();
    }

    public Set<Node> getActiveNodesWithConnector(String connectorName) {
        return this.nodeManager.getActiveDatasourceNodes(connectorName);
    }

    private static void updateDatasourcesAnnouncement(Announcer announcer, String connectorId) {
        ServiceAnnouncement announcement = TestingPrestoServer.getPrestoAnnouncement(announcer.getServiceAnnouncements());
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(announcement.getProperties());
        String property = Strings.nullToEmpty((String)((String)properties.get("datasources")));
        LinkedHashSet<String> datasources = new LinkedHashSet<String>(Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)property));
        datasources.add(connectorId);
        properties.put("datasources", Joiner.on((char)',').join(datasources));
        announcer.removeServiceAnnouncement(announcement.getId());
        announcer.addServiceAnnouncement(ServiceAnnouncement.serviceAnnouncement((String)announcement.getType()).addProperties(properties).build());
        announcer.forceAnnounce();
    }

    private static ServiceAnnouncement getPrestoAnnouncement(Set<ServiceAnnouncement> announcements) {
        for (ServiceAnnouncement announcement : announcements) {
            if (!announcement.getType().equals("presto")) continue;
            return announcement;
        }
        throw new RuntimeException("Presto announcement not found: " + announcements);
    }
}

